/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractOverrideMethodCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.1")
@CheckID(value="R.1300")
@CheckName(value="R.1300")
@CheckLabel(labels={RuleLabel.FACTORY_OVERRIDE, RuleLabel.TEST, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use factory overrides outside of tests")
@CheckDescription(value="This rule flags the usage of type and instance overrides outside of class xvm_test.\n\nExamples:\nclass object_class extends xvm_object;\n\tfunction void foo();\n\t\txvm_factory::get().set_type_override_by_type(original_type, override_type, 1); // NOT ALLOWED\n\tendfunction\nendclass\n\nclass test_class extends xvm_test;\n\tfunction void foo();\n\t\txvm_factory::get().set_type_override_by_type(original_type, override_type, 1); // ALLOWED\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1300
extends AbstractOverrideMethodCheck {
    private final String globalXVMObjectName;

    public Check_R_1300(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.globalXVMObjectName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object");
    }

    @Override
    public void performCheckImpl() {
        final Set<RfFunction> overrideMethods = this.getOverrideMethods();
        RfClass objectClass = this.fOVMProject.getRfProject().getClass(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::" + this.globalXVMObjectName), true);
        Set<RfClass> classes = this.fOVMProject.getAllXVMSubClasses(objectClass);
        for (RfClass clazz : classes) {
            if (LintUtils.isSubClassOf(clazz, this.fOVMProject.fOvmTest)) continue;
            clazz.visitHidObject(null, new RfHidVisitor(){

                public boolean visit(RfHid hidObject) {
                    Check_R_1300.this.notifyCheckAlive();
                    if (Check_R_1300.this.checkPreWaivers(this.parserPath)) {
                        return true;
                    }
                    IRfNamedElement elem = hidObject.getElement();
                    if (!(elem instanceof RfFunction)) {
                        return true;
                    }
                    if (overrideMethods != null && !overrideMethods.contains(elem)) {
                        return true;
                    }
                    Check_R_1300.this.addHit(this.parserPath, hidObject.getOccurrence(), "Method '" + LintUtils.getNamedElementFullName((RfNamedElement)elem) + "' is used to override outside of a test!");
                    return true;
                }
            });
        }
    }

    private Set<RfFunction> getOverrideMethods() {
        HashSet<RfFunction> overrideMethods = new HashSet<RfFunction>();
        RfPackage xvmPackage = this.getXVMPackage();
        if (xvmPackage == null) {
            return null;
        }
        Map<RfFunction, Function<RfHidAccessArgs, List<IHidObject>>> factoryOverride = this.getOverrideMethodsMap();
        if (factoryOverride != null) {
            overrideMethods.addAll(factoryOverride.keySet());
        }
        RfFunction xvmMethod = null;
        RfClass xvmClass = null;
        xvmClass = this.getXVMClass(xvmPackage, "_component_registry");
        if (xvmClass != null) {
            xvmMethod = this.getXVMFunction(xvmClass, "set_type_override");
            if (xvmMethod != null) {
                overrideMethods.add(xvmMethod);
            }
            if ((xvmMethod = this.getXVMFunction(xvmClass, "set_inst_override")) != null) {
                overrideMethods.add(xvmMethod);
            }
        }
        if (this.fOVMProject.getLibraryKind() == 2 && (xvmClass = this.getXVMClass(xvmPackage, "_default_factory")) != null) {
            xvmMethod = this.getXVMFunction(xvmClass, "set_type_override_by_type");
            if (xvmMethod != null) {
                overrideMethods.add(xvmMethod);
            }
            if ((xvmMethod = this.getXVMFunction(xvmClass, "set_type_override_by_name")) != null) {
                overrideMethods.add(xvmMethod);
            }
            if ((xvmMethod = this.getXVMFunction(xvmClass, "set_inst_override_by_type")) != null) {
                overrideMethods.add(xvmMethod);
            }
            if ((xvmMethod = this.getXVMFunction(xvmClass, "set_inst_override_by_name")) != null) {
                overrideMethods.add(xvmMethod);
            }
        }
        return overrideMethods;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

