/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckReapplyDisable
@CheckVersion(value="24.1.7")
@CheckID(value="R.1301")
@CheckName(value="R.1301")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.ANALYSIS_PORT, RuleLabel.AGENT, RuleLabel.SUBSCRIBER, RuleLabel.SCOREBOARD, RuleLabel.VERIFICATION})
@CheckTitle(value="Connect the analysis port of the agent to a subscriber or scoreboard")
@CheckDescription(value="Every agent should connect to its scoreboard or subscriber.\nThat connection should be done using a 'xvm_analysis_port' port\n\nExamples:\nclass my_agent extends xvm_agent;\n  xvm_analysis_port#(my_transaction) a_port;\n  xvm_port_base#(my_transaction) port;\n  my_subscriber m_subscriber;\n\n  m_subscriber.a_port.connect( a_port ); //allowed\n  m_subscriber.a_port.connect( port );   // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1301
extends OVMComplianceCheck {
    private String xvmPortConnect;
    private String xvmAnalysisPortName;
    RfClass xvmSubscriber;
    RfClass xvmAnalysis;
    RfClass xvmBasePort;
    Set<RfClass> baseClasses;
    Set<RfClass> agents;

    public Check_R_1301(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.xvmPortConnect = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base.connect");
        this.xvmAnalysisPortName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_analysis_port");
        String xvmAgentName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_agent");
        if (this.fOVMProject.fOvmAgent == null) {
            this.addHit(null, "Class '" + xvmAgentName + "' not found!");
            return;
        }
        String xvmScoreboardName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_scoreboard");
        if (this.fOVMProject.fOvmScoreboard == null) {
            this.addHit(null, "Class '" + xvmScoreboardName + "' not found!");
            return;
        }
        String xvmSubscriberName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_subscriber");
        this.xvmSubscriber = this.fOVMProject.getRfProject().getClass(xvmSubscriberName, true);
        if (this.xvmSubscriber == null) {
            this.addHit(null, "Class '" + xvmSubscriberName + "' not found!");
            return;
        }
        String xvmAnalysisName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_analysis_port");
        this.xvmAnalysis = this.fOVMProject.getRfProject().getClass(xvmAnalysisName, true);
        if (this.xvmAnalysis == null) {
            this.addHit(null, "Class '" + xvmAnalysisName + "' not found!");
            return;
        }
        this.baseClasses = new HashSet<RfClass>(Arrays.asList(this.xvmSubscriber, this.fOVMProject.fOvmScoreboard));
        this.agents = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmAgent);
        ConnectVisitor visitor = new ConnectVisitor();
        RfProject rfProject = this.fOVMProject.getRfProject();
        rfProject.visitHidObject(null, visitor);
        for (RfClass agent : this.agents) {
            this.addHit(agent, "Agent '" + LintUtils.getNamedElementFullName(agent) + "' doesn't have any connections to scoreboards or subscribers through '" + this.xvmAnalysisPortName + "' ports!");
        }
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class ConnectVisitor
    extends RfHidVisitor {
        private ConnectVisitor() {
        }

        public boolean visit(RfHid rfHid) {
            boolean isAgentPort;
            String name = LintUtils.getFileShortName(this.parserPath.path);
            if (Check_R_1301.this.fOVMProject.isOVMFile(name)) {
                return true;
            }
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            if (Check_R_1301.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            Check_R_1301.this.notifyCheckAlive();
            IRfNamedElement element = rfHid.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (!((RfFunction)element).getFullName().equals(Check_R_1301.this.xvmPortConnect)) {
                return true;
            }
            Hid portHid = rfHid.getParentHid();
            if (portHid == null || !(portHid instanceof RfHid)) {
                return true;
            }
            IRfNamedElement portElement = portHid.getElement();
            if (!(portElement instanceof RfField)) {
                return true;
            }
            RfClass enclosingScope = (RfClass)portElement.getEnclosingScope(RfClass.class);
            if (LintUtils.isSubClassOf(enclosingScope, ((Check_R_1301)Check_R_1301.this).fOVMProject.fOvmAgent)) {
                isAgentPort = true;
            } else if (LintUtils.isSubClassOfAny(enclosingScope, Check_R_1301.this.baseClasses)) {
                isAgentPort = false;
            } else {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            for (MethodCall call : methodCalls) {
                if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                    RfField configField;
                    IRfFieldElement key = (IRfFieldElement)entry.getKey();
                    if (!(key instanceof RfField) || !(configField = (RfField)key).getName().equals("provider")) continue;
                    IHidObject value = (IHidObject)entry.getValue();
                    if (value == null || !(value instanceof RfHid)) {
                        return true;
                    }
                    IRfNamedElement portElementArg = ((RfHid)value).getElement();
                    if (!(portElementArg instanceof RfField)) {
                        return true;
                    }
                    RfClass enclosingScopeArg = (RfClass)portElementArg.getEnclosingScope(RfClass.class);
                    if (LintUtils.isSubClassOf(enclosingScopeArg, ((Check_R_1301)Check_R_1301.this).fOVMProject.fOvmAgent) && !isAgentPort || LintUtils.isSubClassOfAny(enclosingScopeArg, Check_R_1301.this.baseClasses) && isAgentPort) {
                        this.checkAnalysisPort((RfHid)portHid, rfHid);
                        this.checkAnalysisPort((RfHid)value, rfHid);
                        if (isAgentPort) {
                            Check_R_1301.this.agents.remove(enclosingScope);
                            continue;
                        }
                        Check_R_1301.this.agents.remove(enclosingScopeArg);
                        continue;
                    }
                    return true;
                }
            }
            return true;
        }

        void checkAnalysisPort(RfHid analysisPort, RfHid connectHid) {
            RfClass portClass;
            IRfNamedElement portElement = analysisPort.getElement();
            if (portElement == null || !(portElement instanceof RfField)) {
                this.addHitConnection(connectHid, analysisPort);
            }
            if ((portClass = LintUtils.getFieldFinalClassTypeOrNull((RfField)portElement)) == null || !LintUtils.isSubClassOf(portClass, Check_R_1301.this.xvmAnalysis) && !LintUtils.isInsideMacroWithName(portClass, new HashSet<String>(Arrays.asList("uvm_analysis_imp_decl")))) {
                this.addHitConnection(connectHid, analysisPort);
            }
        }

        private void addHitConnection(RfHid connectHid, RfHid portHid) {
            Check_R_1301.this.addHit(this.parserPath, connectHid, "Port connection '" + LintUtils.getHidFullName((IHid)portHid) + "' should be of type '" + Check_R_1301.this.xvmAnalysisPortName + "'!");
        }
    }
}

