/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.1")
@CheckID(value="R.1302")
@CheckName(value="R.1302")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.REGISTER_MODEL, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Before starting a sequence that reads or writes registers set the regmodel variable of the sequence")
@CheckDescription(value="Sequences with regmodel must have regmodel assignment either before calling start of that seq, or in the body of the seq, first statement.\n\nExemples:\n\nclass my_reg_sequence extends uvm_sequence;\n\t`uvm_object_utils(my_reg_sequence)\n\tuvm_reg_block regmodel;\n\n\tvirtual task body();\n\t\tregmodel = new();\n\tendtask\nendclass\n\nOR\n\ntask test_body();\n\tmy_reg_sequence vseq;\n\tvseq = my_reg_sequence::type_id::create(&quot;vseq&quot;);\n\tvseq.randomize();\n\tvseq.regmodel = regmodel;\n\tvseq.set_starting_phase(phase);\n\tvseq.start(null);\nendtask\n\nCheck supports pre-waiving.")
public class Check_R_1302
extends OVMComplianceCheck {
    private RfClass sequenceBaseClass;
    private Map<RfClass, Set<RfField>> sequenceToRegBlocks;
    private Set<RfField> currentRegblocks;
    private Set<RfField> assigned;
    private TreeMap<Integer, DVTPair<Integer, RfField>> boundariesOfRegblockAssignment;
    private Map<RfClass, Map<RfHid, HidOccurrence>> startOfSequences;
    private Map<RfClass, Map<RfHid, HidOccurrence>> firstOccurrenceOfRegmodelsPerSequence;

    public Check_R_1302(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.sequenceToRegBlocks = new HashMap<RfClass, Set<RfField>>();
        this.assigned = new HashSet<RfField>();
        this.currentRegblocks = new HashSet<RfField>();
        this.startOfSequences = new HashMap<RfClass, Map<RfHid, HidOccurrence>>();
        this.firstOccurrenceOfRegmodelsPerSequence = new HashMap<RfClass, Map<RfHid, HidOccurrence>>();
        RfClass sequenceClass = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_sequence", true);
        this.sequenceBaseClass = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_sequence_base", true);
        RfClass regBlockClass = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_reg_block", true);
        Set<RfClass> sequences = this.fOVMProject.getAllXVMSubClasses(sequenceClass);
        block0: for (RfClass sequence : sequences) {
            List<RfField> classFields = sequence.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (classFields == null) continue;
            for (RfField field : classFields) {
                String type = field.getDataType().getType();
                RfClass fieldClass = this.fOVMProject.getRfProject().getClass(type, false);
                if (!LintUtils.isSubClassOf(fieldClass, regBlockClass)) continue;
                if (!this.sequenceToRegBlocks.containsKey(sequence)) {
                    this.sequenceToRegBlocks.put(sequence, new HashSet());
                }
                this.sequenceToRegBlocks.get(sequence).add(field);
            }
            if (!this.sequenceToRegBlocks.containsKey(sequence)) continue;
            this.currentRegblocks = this.sequenceToRegBlocks.get(sequence);
            List<RfFunction> classTasks = sequence.getLocalTasks();
            for (RfFunction task : classTasks) {
                if (!task.getName().equals("body")) continue;
                this.boundariesOfRegblockAssignment = new TreeMap();
                task.visitHidObject(null, (IHidVisitor<?>)new SequenceBodyOperatorsVisitor());
                task.visitHidObject(null, new TaskRfHidVisitor());
                task.visitHidObject(null, new SequenceFuncCallVisitor(true));
                for (Map.Entry<Integer, DVTPair<Integer, RfField>> boundary : this.boundariesOfRegblockAssignment.entrySet()) {
                    this.assigned.add((RfField)boundary.getValue().getValue());
                }
                continue block0;
            }
        }
        for (RfClass clazz : this.fOVMProject.getAllClasses()) {
            List<RfFunction> localFunctions;
            if (sequences.contains(clazz)) continue;
            ArrayList<RfFunction> localMethods = new ArrayList<RfFunction>();
            List<RfFunction> localTasks = clazz.getLocalTasks();
            if (localTasks != null) {
                localMethods.addAll(localTasks);
            }
            if ((localFunctions = clazz.getLocalFunctions()) != null) {
                localMethods.addAll(localFunctions);
            }
            for (RfFunction method : localMethods) {
                this.startOfSequences = new HashMap<RfClass, Map<RfHid, HidOccurrence>>();
                this.firstOccurrenceOfRegmodelsPerSequence = new HashMap<RfClass, Map<RfHid, HidOccurrence>>();
                method.visitHidObject(null, new SequenceStartRfHidVisitor());
                if (this.startOfSequences.isEmpty()) continue;
                for (RfClass rfClass : this.startOfSequences.keySet()) {
                    this.firstOccurrenceOfRegmodelsPerSequence.put(rfClass, new HashMap());
                }
                method.visitHidObject(null, (IHidVisitor<?>)new BeforeStartOperatorsVisitor());
                method.visitHidObject(null, new SequenceFuncCallVisitor(false));
                for (Map.Entry entry : this.firstOccurrenceOfRegmodelsPerSequence.entrySet()) {
                    RfClass sequence = (RfClass)entry.getKey();
                    HashMap localAssignedRegmodels = new HashMap();
                    for (RfHid rfHid : this.startOfSequences.get(sequence).keySet()) {
                        localAssignedRegmodels.put(rfHid, new HashSet());
                    }
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        Hid hidOfSequenceStart = ((RfHid)((Object)entry2.getKey())).getParentAccess().getParentHid();
                        if (hidOfSequenceStart == null || !(hidOfSequenceStart instanceof RfHid)) continue;
                        RfField regmodelField = (RfField)((RfHid)((Object)entry2.getKey())).getElement();
                        if (((HidOccurrence)entry2.getValue()).getOffset() >= this.startOfSequences.get(sequence).get(hidOfSequenceStart).getOffset()) continue;
                        ((Set)localAssignedRegmodels.get(hidOfSequenceStart)).add(regmodelField);
                    }
                    for (RfField rfField : this.sequenceToRegBlocks.get(sequence)) {
                        for (Map.Entry assignedFields : localAssignedRegmodels.entrySet()) {
                            if (((Set)assignedFields.getValue()).contains(rfField) || this.assigned.contains(rfField)) continue;
                            this.addHit(rfField.getFile().getParserPath(), (RfHid)((Object)assignedFields.getKey()), "Register block '" + LintUtils.getNamedElementFullName(rfField) + "' is not initialized in the body or before calling start of this sequence!");
                        }
                    }
                }
            }
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.sequenceToRegBlocks != null) {
            this.sequenceToRegBlocks.clear();
        }
        if (this.currentRegblocks != null) {
            this.currentRegblocks.clear();
        }
        if (this.assigned != null) {
            this.assigned.clear();
        }
        if (this.boundariesOfRegblockAssignment != null) {
            this.boundariesOfRegblockAssignment.clear();
        }
        if (this.startOfSequences != null) {
            this.startOfSequences.clear();
        }
        if (this.firstOccurrenceOfRegmodelsPerSequence != null) {
            this.firstOccurrenceOfRegmodelsPerSequence.clear();
        }
    }

    private class BeforeStartOperatorsVisitor
    extends HidOperatorVisitor {
        public BeforeStartOperatorsVisitor() {
            super(null);
        }

        public boolean visit(HidOperator operator) {
            Check_R_1302.this.notifyCheckAlive();
            if (Check_R_1302.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!operator.isAssignment()) {
                return true;
            }
            IHidObject leftHand = operator.getLHValue();
            if (leftHand == null || !(leftHand instanceof RfHid)) {
                return true;
            }
            RfHid leftHandHid = (RfHid)leftHand;
            IRfNamedElement leftHandElem = leftHandHid.getElement();
            if (leftHandElem == null || !(leftHandElem instanceof RfField)) {
                return true;
            }
            RfField leftHandField = (RfField)leftHandElem;
            RfClass sequence = leftHandField.getEnclosingScope(RfClass.class);
            if (sequence == null) {
                return true;
            }
            if (Check_R_1302.this.assigned.contains(leftHandField)) {
                return true;
            }
            if (!Check_R_1302.this.startOfSequences.containsKey(sequence)) {
                return true;
            }
            if (!Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.containsKey(sequence)) {
                Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.put(sequence, new HashMap());
            }
            if (!Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.get(sequence).containsKey((Object)leftHandHid)) {
                Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.get(sequence).put(leftHandHid, leftHandHid.getOccurrence());
            } else {
                HidOccurrence savedOccurrence = Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.get(sequence).get((Object)leftHandHid);
                if (leftHandHid.getOccurrence().getOffset() < savedOccurrence.getOffset()) {
                    Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.get(sequence).put(leftHandHid, leftHandHid.getOccurrence());
                }
            }
            return true;
        }
    }

    private class SequenceBodyOperatorsVisitor
    extends HidOperatorVisitor {
        public SequenceBodyOperatorsVisitor() {
            super(null);
        }

        public boolean visit(HidOperator operator) {
            Check_R_1302.this.notifyCheckAlive();
            if (Check_R_1302.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!operator.isAssignment()) {
                return true;
            }
            IHidObject leftHand = operator.getLHValue();
            if (leftHand == null || !(leftHand instanceof RfHid)) {
                return true;
            }
            RfHid leftHandHid = (RfHid)leftHand;
            IRfNamedElement leftHandElem = leftHandHid.getElement();
            if (leftHandElem == null || !(leftHandElem instanceof RfField)) {
                return true;
            }
            RfField leftHandField = (RfField)leftHandElem;
            if (!Check_R_1302.this.currentRegblocks.contains(leftHandField)) {
                return true;
            }
            Check_R_1302.this.boundariesOfRegblockAssignment.put(operator.getOpenBoundary(), (DVTPair<Integer, RfField>)new DVTPair((Object)operator.getCloseBoundary(), (Object)leftHandField));
            return true;
        }
    }

    private class SequenceFuncCallVisitor
    extends RfHidVisitor {
        boolean isInBody;

        public SequenceFuncCallVisitor(boolean isInBody) {
            this.isInBody = isInBody;
        }

        public boolean visit(RfHid hidObject) {
            Check_R_1302.this.notifyCheckAlive();
            if (Check_R_1302.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            IRfNamedElement namedElement = hidObject.getElement();
            if (!(namedElement instanceof RfFunction)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            for (MethodCall call : methodCalls) {
                if (call.argumentValuesMapRaw == null) continue;
                for (Map.Entry argumentEntry : call.argumentValuesMapRaw.entrySet()) {
                    RfHid regHid;
                    IRfNamedElement regHidElem;
                    IHidObject reg;
                    RfField field;
                    if (!(argumentEntry.getKey() instanceof RfField) || !(field = (RfField)argumentEntry.getKey()).isInout() && (!field.isRef() || field.isConstRef()) && !field.isOutput() || (reg = (IHidObject)argumentEntry.getValue()) == null || !(reg instanceof RfHid) || (regHidElem = (regHid = (RfHid)reg).getElement()) == null || !(regHidElem instanceof RfField)) continue;
                    RfField regHidField = (RfField)regHidElem;
                    if (this.isInBody && !Check_R_1302.this.currentRegblocks.contains(regHidField) || Check_R_1302.this.assigned.contains(regHidField)) continue;
                    if (!this.isInBody) {
                        Set<RfField> regBlocks;
                        RfClass sequence = regHidField.getEnclosingScope(RfClass.class);
                        if (sequence == null || (regBlocks = Check_R_1302.this.sequenceToRegBlocks.get(sequence)) == null || !regBlocks.contains(regHidField) || !Check_R_1302.this.startOfSequences.containsKey(sequence)) continue;
                        if (!Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.containsKey(sequence)) {
                            Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.put(sequence, new HashMap());
                        }
                        if (!Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.get(sequence).containsKey((Object)regHid)) {
                            Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.get(sequence).put(regHid, regHid.getOccurrence());
                            continue;
                        }
                        HidOccurrence savedOccurrence = Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.get(sequence).get((Object)regHid);
                        if (regHid.getOccurrence().getOffset() >= savedOccurrence.getOffset()) continue;
                        Check_R_1302.this.firstOccurrenceOfRegmodelsPerSequence.get(sequence).put(regHid, regHid.getOccurrence());
                        continue;
                    }
                    Check_R_1302.this.assigned.add(regHidField);
                }
            }
            return true;
        }
    }

    private class SequenceStartRfHidVisitor
    extends RfHidVisitor {
        private SequenceStartRfHidVisitor() {
        }

        public boolean visit(RfHid rfHid) {
            Check_R_1302.this.notifyCheckAlive();
            if (Check_R_1302.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            IRfNamedElement elem = rfHid.getElement();
            if (elem == null || !(elem instanceof RfFunction)) {
                return true;
            }
            if (!elem.getName().equals("start")) {
                return true;
            }
            RfClass enclosingClass = (RfClass)elem.getEnclosingScope(RfClass.class);
            if (!LintUtils.isSubClassOf(enclosingClass, Check_R_1302.this.sequenceBaseClass)) {
                return true;
            }
            Hid parent = rfHid.getParentHid();
            if (parent == null || !(parent instanceof RfHid)) {
                return true;
            }
            IRfNamedElement parentElem = parent.getElement();
            if (parentElem == null || !(parentElem instanceof RfField)) {
                return true;
            }
            RfField parentField = (RfField)parentElem;
            IRfNamedElement typeOfParent = parentField.getResolvedType(false);
            if (typeOfParent == null || !(typeOfParent instanceof RfClass) || !Check_R_1302.this.sequenceToRegBlocks.containsKey(typeOfParent)) {
                return true;
            }
            if (!Check_R_1302.this.startOfSequences.containsKey(typeOfParent)) {
                Check_R_1302.this.startOfSequences.put((RfClass)typeOfParent, new HashMap());
            }
            if (!Check_R_1302.this.startOfSequences.get(typeOfParent).containsKey(parent) || parent.getOffset() < Check_R_1302.this.startOfSequences.get(typeOfParent).get(parent).getOffset()) {
                Check_R_1302.this.startOfSequences.get(typeOfParent).put((RfHid)parent, parent.getOccurrence());
            }
            return true;
        }
    }

    private class TaskRfHidVisitor
    extends RfHidVisitor {
        private TaskRfHidVisitor() {
        }

        public boolean visit(RfHid rfHid) {
            Check_R_1302.this.notifyCheckAlive();
            if (Check_R_1302.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            int currentHidOffset = rfHid.getOccurrence().getOffset();
            for (Map.Entry<Integer, DVTPair<Integer, RfField>> regAssignment : Check_R_1302.this.boundariesOfRegblockAssignment.entrySet()) {
                Integer start = regAssignment.getKey();
                Integer end = (Integer)regAssignment.getValue().getKey();
                if (currentHidOffset < start || currentHidOffset > end) continue;
                return true;
            }
            Iterator<Map.Entry<Integer, DVTPair<Integer, RfField>>> itr = Check_R_1302.this.boundariesOfRegblockAssignment.entrySet().iterator();
            while (itr.hasNext()) {
                if (itr.next().getKey() < currentHidOffset) continue;
                itr.remove();
            }
            return true;
        }
    }
}

