/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="24.1.1")
@CheckID(value="R.1303")
@CheckName(value="R.1303")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.ENVIRONMENT, RuleLabel.REGISTER_MODEL, RuleLabel.COMPONENT, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Any UVM environment that has a register model should set the register model variable of any child component")
@CheckDescription(value="If in an environment there is a register model that has children, then all environments and components that have a register model field should set that field to the register model of the parent environment.\n\nExamples:\nmy_env m_env;;           // allowed\nmy_comp m_comp;          // not allowed\n\nfunction void build_phase(uvm_phase phase);\n  m_env.regmodel = regmodel.env_reg_field;\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1303
extends OVMComplianceCheck {
    private static final String UVM_REG_BLOCK = "uvm_pkg::uvm_reg_block";
    private RfClass uvmRegBlock;

    public Check_R_1303(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.uvmRegBlock = this.fOVMProject.getRfProject().getClass(UVM_REG_BLOCK, true);
        if (this.uvmRegBlock == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_reg_block' not found!");
            return;
        }
        if (this.fOVMProject.fOvmComponent == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_component' not found!");
            return;
        }
        if (this.fOVMProject.fOvmEnv == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_env' not found!");
            return;
        }
        Set<RfClass> allEnv = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmEnv);
        for (RfClass env : allEnv) {
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(env.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List<RfField> fields = env.getFields();
            if (fields == null || fields.isEmpty()) continue;
            HashSet<RfField> envAndCompFields = new HashSet<RfField>();
            HashSet<RfField> regmodelFields = new HashSet<RfField>();
            for (RfField field : fields) {
                RfClass fieldClass = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldClass == null || !this.hasRegModelField(fieldClass)) continue;
                if (LintUtils.isSubClassOf(fieldClass, this.uvmRegBlock)) {
                    regmodelFields.add(field);
                    continue;
                }
                if (!LintUtils.isSubClassOf(fieldClass, this.fOVMProject.fOvmComponent)) continue;
                envAndCompFields.add(field);
            }
            if (regmodelFields.isEmpty() || envAndCompFields.isEmpty()) continue;
            RfFunction buildPhase = env.getFunctionWithPrefix("build_phase", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (buildPhase != null) {
                buildPhase.visitHidObject(null, (IHidVisitor<?>)new BuildPhaseVisitor(envAndCompFields, regmodelFields));
            }
            for (RfField field : envAndCompFields) {
                this.addHit(field, "Register model is not set for field '" + LintUtils.getNamedElementFullName(field) + "'!");
            }
        }
    }

    private boolean hasRegModelField(RfClass clazz) {
        if (this.fOVMProject.isOVMElement(clazz)) {
            return false;
        }
        List<RfField> fields = clazz.getFields();
        if (fields == null || clazz.isEmpty()) {
            return false;
        }
        for (RfField field : fields) {
            RfClass fieldClass = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (fieldClass == null || !LintUtils.isSubClassOf(fieldClass, this.uvmRegBlock)) continue;
            return true;
        }
        return false;
    }

    private class BuildPhaseVisitor
    extends HidOperatorVisitor {
        private Set<RfField> envAndCompFields;
        private Set<RfField> regmodelFields;

        public BuildPhaseVisitor(Set<RfField> envAndCompFields, Set<RfField> regmodelFields) {
            super(null);
            this.envAndCompFields = envAndCompFields;
            this.regmodelFields = regmodelFields;
        }

        public boolean visit(HidOperator operator) {
            if (!operator.isAssignment()) {
                return true;
            }
            IHidObject rhValue = operator.getFirstRHValue();
            IRfNamedElement rhElement = this.getHidElement(rhValue);
            if (rhElement == null || !this.regmodelFields.contains(rhElement)) {
                return true;
            }
            IHidObject lhValue = operator.getLHValue();
            IRfNamedElement lhElement = this.getHidElement(lhValue);
            if (lhElement == null) {
                return true;
            }
            this.envAndCompFields.remove(lhElement);
            return true;
        }

        private IRfNamedElement getHidElement(IHidObject iHidObject) {
            if (!(iHidObject instanceof RfHid)) {
                return null;
            }
            RfHid rfHid = (RfHid)iHidObject;
            IRfNamedElement element = rfHid.getElement();
            if (!(element instanceof RfField)) {
                return null;
            }
            RfClass fieldClass = LintUtils.getFieldFinalClassTypeOrNull((RfField)element);
            if (!LintUtils.isSubClassOf(fieldClass, Check_R_1303.this.uvmRegBlock)) {
                return null;
            }
            Hid parentHid = rfHid.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return null;
            }
            element = ((RfHid)parentHid).getElement();
            return element;
        }
    }
}

