/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.2.28")
@CheckID(value="R.1304")
@CheckName(value="R.1304")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.REGISTER_MODEL, RuleLabel.VERIFICATION, RuleLabel.RAL})
@CheckTitle(value="Use explicit prediction in a register model")
@CheckDescription(value="It is recommended to use explicit prediction in a register model in order to keep mirror values synchronized with register values in the DUT.\nThis check flags using implicit prediction by calling 'set_auto_predict' with argument '1'.\nClasses that extend from uvm_env and do not have a field of type uvm_reg_predictor or child of uvm_reg_predictor are also flagged.\n\nExamples:\n\nclass my_class extends uvm_env; // not allowed\n  uvm_reg_block regmodel;\n\n  function void foo();\n    regmodel.default_map.set_auto_predict(1); // not allowed\n  endfunction\nendclass\n\nclass my_env extends uvm_env;\n  uvm_reg_predictor predictor; // allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1304
extends OVMComplianceCheck {
    private String fullMethodName;

    public Check_R_1304(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.fullMethodName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_reg_map.set_auto_predict");
        LocalRfHidVisitor hidVisitor = new LocalRfHidVisitor(this.fOVMProject);
        rfProject.visitHidObject(rfProject, hidVisitor);
        String predictorClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_reg_predictor");
        RfClass predictorClass = this.fOVMProject.getRfProject().getClass(predictorClassName, true);
        if (predictorClass == null) {
            return;
        }
        HashSet checkedClasses = (HashSet)this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmEnv);
        if (checkedClasses == null || checkedClasses.isEmpty()) {
            return;
        }
        for (RfClass clazz : checkedClasses) {
            this.notifyCheckAlive();
            RfFileDef file = clazz.getFile();
            if (file == null || this.checkPreWaivers(file.getParserPath())) continue;
            ArrayList fields = (ArrayList)clazz.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            boolean hasPredictorField = false;
            if (!fields.isEmpty()) {
                for (RfField field : fields) {
                    RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                    if (fieldType == null || !LintUtils.isSubClassOf(fieldType, predictorClass)) continue;
                    hasPredictorField = true;
                    break;
                }
            }
            if (hasPredictorField) continue;
            this.addHit(clazz, "Class '" + LintUtils.getNamedElementFullName(clazz) + "' does not have a '" + predictorClassName + "' field!");
        }
    }

    protected boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalRfHidVisitor
    extends RfHidVisitor {
        private RfNamedElement scope;
        private OVMProject proj;

        public LocalRfHidVisitor(OVMProject fOVMProject) {
            this.proj = fOVMProject;
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (Check_R_1304.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1304.this.notifyCheckAlive();
            RfClass clazz = this.scope.getEnclosingScope(RfClass.class);
            if (clazz == null || this.proj.isOVMElement(clazz)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hidObject.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            RfFunction calledFunction = (RfFunction)hidNamedElement;
            String calledFunctionFullName = LintUtils.getNamedElementFullName(calledFunction);
            if (!Check_R_1304.this.fullMethodName.equals(calledFunctionFullName)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    IHidObject argumentRaw = (IHidObject)entry.getValue();
                    if (!(argumentRaw instanceof RfHidImplicit) || !"1".equals(((RfHidImplicit)argumentRaw).getName())) continue;
                    Check_R_1304.this.addHit(this.parserPath, methodCall.getOccurrence(), "Implicit prediction used by calling method '" + calledFunctionFullName + "' with argument '1' in class: '" + LintUtils.getNamedElementFullName(clazz) + "'!");
                }
            }
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

