/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.EnumSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.2.29")
@CheckID(value="R.1305")
@CheckName(value="R.1305")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.OPERATOR, RuleLabel._4_STATE})
@CheckTitle(value="Do not use the replication operator for multi-bit X or Z values")
@CheckDescription(value="Multi-bit X or Z values should be expressed without using a replication operator.\n\nExamples:\n\nvalue = {4{1'bx}; // not allowed\nvalue = 4'bxxxx;  // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1305
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="X, Z", description="Comma separated list of: X, Z.", name="checkedValue", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pCheckedValue;
    private boolean checkX;
    private boolean checkZ;

    @Override
    public void configure() {
        super.configure();
        if (this.pCheckedValue.isEmpty()) {
            this.signalParamError("Parameter 'checkedValue' cannot be empty!", true);
        }
        for (String value : this.pCheckedValue) {
            if ("X".equals(value) || "Z".equals(value)) continue;
            this.signalParamError("Invalid value '" + value + "' for parameter checkedValue!", true);
        }
    }

    public Check_R_1305(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkX = this.pCheckedValue.contains("X");
        this.checkZ = this.pCheckedValue.contains("Z");
        this.fOVMProject.getRfProject().visitHidObject(null, new ReplicationOperatorVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class ReplicationOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        private ReplicationOperatorVisitor() {
        }

        public boolean visit(RfHidOperator hidOperator) {
            if (!hidOperator.isReplication()) {
                return true;
            }
            if (Check_R_1305.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1305.this.notifyCheckAlive();
            Set flattenHids = HidUtils.flattenToHids((IHidObject)hidOperator, EnumSet.of(HidFlatteningOption.IGNORE_HIDS));
            if (flattenHids == null || flattenHids.isEmpty()) {
                return true;
            }
            for (IHid hid : flattenHids) {
                if (!(hid instanceof RfHidImplicit)) continue;
                RfHidImplicit hidImplicit = (RfHidImplicit)hid;
                String numberString = hidImplicit.getName();
                if (!hidImplicit.isNumber() || hidImplicit.getType() == 283 || (!Check_R_1305.this.checkX || !numberString.toUpperCase().contains("X")) && (!Check_R_1305.this.checkZ || !numberString.toUpperCase().contains("Z"))) continue;
                Check_R_1305.this.addHit(this.parserPath, hidOperator, hidOperator.getQualifiers(), "Replication operator used for multi-bit '" + (Check_R_1305.this.checkX ? "X" : "Z") + "' value '" + HidUtils.toNiceString((IHidObject)hidOperator) + "'!");
                break;
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

