/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.1")
@CheckID(value="R.1306")
@CheckName(value="R.1306")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.EVENT_CONTROL, RuleLabel.EDGE})
@CheckTitle(value="Do not use edge event control")
@CheckDescription(value="Do not use edge event control.\nDo not use the 'edge' event control since some simulators might not support it.\n\nExamples:\nmodule test(input in, output reg previous_in);\n  always @(edge in) begin // not allowed\n  end\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1306
extends OVMComplianceCheck {
    public Check_R_1306(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new EdgeEventVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class EdgeEventVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        EdgeEventVisitor() {
        }

        public boolean visit(RfHidOperator hid) {
            if (hid == null) {
                return true;
            }
            if (Check_R_1306.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1306.this.notifyCheckAlive();
            if (hid.isEventControl()) {
                Set operators = HidUtils.flattenToOperators((IHidOperator)hid);
                if (operators == null || operators.isEmpty()) {
                    return true;
                }
                for (IHidOperator operator : operators) {
                    RfHidOperator hidOperator;
                    if (!(operator instanceof RfHidOperator) || !(hidOperator = (RfHidOperator)operator).isEdgeEvent()) continue;
                    Check_R_1306.this.addHit(this.parserPath, (HidOccurrence)hid.getOccurrence(), "Do not use the 'edge' event control!");
                    return true;
                }
                return true;
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

