/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.1")
@CheckID(value="R.1307")
@CheckName(value="R.1307")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.ASSIGNMENT, RuleLabel.CONDITIONAL})
@CheckTitle(value="Do not use assignments in conditional expressions")
@CheckDescription(value="Do not use assignments in conditional expressions because some simulators may not support them.\n\nExample:\nif ((var = 1))    // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1307
extends OVMComplianceCheck {
    public Check_R_1307(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new OperatorVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class OperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        OperatorVisitor() {
        }

        public boolean visit(RfHidOperator operator) {
            if (!operator.isConditionalTernary() && !operator.isActionBlockCondition()) {
                return true;
            }
            IHidObject condition = operator.getLHValue();
            if (operator.isCaseItemCondition()) {
                condition = operator.getFirstRHValue();
            }
            if (!(condition instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator conditionOperator = (RfHidOperator)condition;
            if (Check_R_1307.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1307.this.notifyCheckAlive();
            Set operators = HidUtils.flattenToOperators((IHidOperator)conditionOperator);
            for (IHidOperator flattenOperator : operators) {
                if (!(flattenOperator instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator hidOperator = (RfHidOperator)flattenOperator;
                if (!hidOperator.isAssignment()) continue;
                Check_R_1307.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), "Assignment '" + HidUtils.toNiceString((IHidObject)hidOperator) + "' used inside conditional expression!");
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

