/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.1")
@CheckID(value="R.1308")
@CheckName(value="R.1308")
@CheckLabel(labels={RuleLabel.PREDEFINED_METHOD, RuleLabel.ARGUMENT})
@CheckTitle(value="The method $assertcontrol should be called with a specific number of arguments")
@CheckDescription(value="Do not call $assertcontrol with more than two arguments since some simulators might not support it\n\nExamples\n\n$assertcontrol(3,1,1); // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1308
extends OVMComplianceCheck {
    public Check_R_1308(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new LocalHidVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class LocalHidVisitor
    extends RfHidVisitor {
        LocalHidVisitor() {
        }

        public boolean visit(RfHid rfHid) {
            if (Check_R_1308.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1308.this.notifyCheckAlive();
            if (!rfHid.isMethodCall(false)) {
                return true;
            }
            if (!rfHid.getName().equals("$assertcontrol")) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.entrySet().size() <= 2) continue;
                Check_R_1308.this.addHit(this.parserPath, rfHid, "$assertcontrol call should be called with maximum 2 arguments!");
            }
            return true;
        }
    }
}

