/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;

@CheckVersion(value="24.1.1")
@CheckID(value="R.1309")
@CheckName(value="R.1309")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.INTERFACE, RuleLabel.DESIGN, RuleLabel.DECLARATION_ASSIGN})
@CheckTitle(value="Do not initialize module and interface variables upon declaration")
@CheckDescription(value="Initializing a module or interface variable on declaration is not recommended because there's a functional difference between the initialization on declaration and further assignments for that variable.\nThis may leed to unexpected behaviour and hard to catch bugs.\n\nExample:\nmodule top;\n  logic a = b;    // not allowed\n\n  logic a;\n  assign a = b;   // allowed\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1309
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of variables types to check. If empty, all variable types will be checked.", name="checkedTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCheckedTypes;

    public Check_R_1309(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement module : this.fOVMProject.getAllModules()) {
            this.checkVariables(module);
        }
        for (RfNamedElement interf : this.fOVMProject.getAllInterfaces()) {
            this.checkVariables(interf);
        }
    }

    private void checkVariables(RfNamedElement element) {
        if (!(element instanceof RfInstanceHolder)) {
            return;
        }
        RfInstanceHolder holder = (RfInstanceHolder)element;
        if (this.checkPreWaivers(holder.getDeclaration().getParserPath())) {
            return;
        }
        this.notifyCheckAlive();
        List<RfField> fields = holder.getLocalFields();
        if (fields == null) {
            return;
        }
        for (RfField field : fields) {
            String initialValue;
            if (field.isParameter() || !this.pCheckedTypes.isEmpty() && !this.shouldCheckVariableType(field) || !(field instanceof RfPort) && field.isNet() || (initialValue = field.getInitialValue(false)) == null || initialValue.isEmpty()) continue;
            this.addHit(field, "Variable '" + field.getName() + "' from " + (element instanceof RfModule ? "module '" : "interface '") + element.getFullName() + "' is initialized upon declaration!");
        }
    }

    private boolean shouldCheckVariableType(RfField field) {
        IRfNamedElement fieldType = LintUtils.getFieldType(field);
        return fieldType != null && this.pCheckedTypes.contains(fieldType.getName());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

