/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.3")
@CheckID(value="R.1310")
@CheckName(value="R.1310")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.VIRTUAL_SEQUENCER, RuleLabel.CONNECT_PHASE, RuleLabel.ENVIRONMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Virtual sequencers must set subsequencers in the connect_phase method of the environment ")
@CheckDescription(value="Virtual sequencers must have at least one subsequencer field and set all subsequencer fields in the connect phase of env.\nThis check flags both not having a subsequencer field in a virtual sequencer and subsequencer fields that are not set.\nA virtual sequencer is a sequencer that extends from xvm_sequencer with the base parameters.\n\nExamples:\n\nvirtual_sequencer vsequencer;\n\nfunction void my_env::connect_phase(uvm_phase phase);\n    vsequencer.subsequencer = agent.sequencer;\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1310
extends OVMComplianceCheck {
    Set<RfField> allSubsequencers;

    public Check_R_1310(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmSequenceItem == null || this.fOVMProject.fOvmEnv == null || this.fOVMProject.fOvmSequencer == null) {
            return;
        }
        Set<RfClass> allEnvClasses = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmEnv);
        this.allSubsequencers = new HashSet<RfField>();
        this.checkSequencer(this.fOVMProject.fOvmSequencer, false);
        for (RfClass env : allEnvClasses) {
            String xvmConnectPhaseMethodName;
            RfFunction connectPhaseFunction;
            this.notifyCheckAlive();
            RfFileDef file = env.getFile();
            if (file == null) {
                return;
            }
            if (this.checkPreWaivers(file.getParserPath()) || (connectPhaseFunction = env.getFunctionWithPrefix(xvmConnectPhaseMethodName = this.fOVMProject.getConnectPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null) continue;
            connectPhaseFunction.visitHidObject(null, new AssignmentVisitor(this.allSubsequencers));
        }
        for (RfField subsequencer : this.allSubsequencers) {
            this.addHit(subsequencer, "Subsequencer '" + LintUtils.getNamedElementFullName(subsequencer) + "' is not set in the connect_phase of the env!");
        }
    }

    private void checkSequencer(RfClass virtualSequencerClass, boolean hasParentWithSubsequencerFields) {
        Set<RfClass> childSequencers = virtualSequencerClass.getChildren();
        if (childSequencers == null) {
            return;
        }
        for (RfClass sequencer : childSequencers) {
            this.notifyCheckAlive();
            RfFileDef file = sequencer.getFile();
            if (file == null) {
                return;
            }
            if (this.checkPreWaivers(file.getParserPath()) || !LintUtils.isVirtualSequencer(sequencer, this.fOVMProject.fOvmSequencer, this.fOVMProject.fOvmSequenceItem)) continue;
            List<RfField> fields = sequencer.getLocalFields();
            HashSet<RfField> subsequencers = new HashSet<RfField>();
            if (fields != null && !fields.isEmpty()) {
                for (RfField field : fields) {
                    RfClass clazz;
                    if (this.fOVMProject.isOVMElement(field) || (clazz = LintUtils.getFieldFinalClassTypeOrNull(field)) == null || !LintUtils.isSubClassOf(clazz, this.fOVMProject.fOvmSequencer)) continue;
                    subsequencers.add(field);
                }
            }
            if (!hasParentWithSubsequencerFields && (subsequencers == null || subsequencers.isEmpty())) {
                this.addHit(sequencer, "Missing subsequencer in '" + LintUtils.getNamedElementFullName(sequencer) + "' virtual sequencer!");
                continue;
            }
            this.allSubsequencers.addAll(subsequencers);
            this.checkSequencer(sequencer, hasParentWithSubsequencerFields || subsequencers != null && !subsequencers.isEmpty());
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class AssignmentVisitor
    implements IHidVisitor<RfHidOperator> {
        private Set<RfField> subsequencers;

        public AssignmentVisitor(Set<RfField> subsequencers) {
            this.subsequencers = subsequencers;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (!hidObject.isAssignment()) {
                return true;
            }
            IHidObject lhValue = hidObject.getLHValue();
            if (lhValue instanceof RfHidAccess) {
                lhValue = ((RfHidAccess)lhValue).getParentHid();
            }
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            Hid hid = (Hid)lhValue;
            while (hid instanceof RfHid) {
                RfField field;
                if (hid.getElement() instanceof RfField && this.subsequencers.remove(field = (RfField)hid.getElement())) {
                    return true;
                }
                hid = hid.getParentHid();
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

