/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

@CheckVersion(value="24.1.1")
@CheckID(value="R.1311")
@CheckName(value="R.1311")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.TYPEDEF})
@CheckTitle(value="Banned typedefs")
@CheckDescription(value="Usages of bannedTypedefs are forbidden.\n\nExample for bannedTypedefs = uvm_pkg::uvm_tlm_gp\n  uvm_tlm_gp generic_payload;   // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1311
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of banned typedefs full names.", name="bannedTypedefs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pBannedTypedefs;

    public Check_R_1311(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pBannedTypedefs.isEmpty()) {
            return;
        }
        LocalNamedElementVisitor typeVisitor = new LocalNamedElementVisitor();
        this.fOVMProject.getRfProject().accept(null, typeVisitor);
    }

    private boolean checkPreWaivers(RfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(defElement.getParserPath(), this);
    }

    class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (Check_R_1311.this.checkPreWaivers(namedElement.getDeclaration())) {
                return true;
            }
            Check_R_1311.this.notifyCheckAlive();
            if (namedElement instanceof RfClass) {
                RfClass clazz = (RfClass)namedElement;
                RfNamedElement scope = namedElement.getEnclosingScope();
                DataType extendedType = clazz.getExtendedType();
                this.checkBannedTypedefWithSameName(extendedType, scope, clazz);
                List<DataType> interfaceTypes = clazz.getImplementedTypes();
                if (interfaceTypes != null && !interfaceTypes.isEmpty()) {
                    for (DataType interfaceType : interfaceTypes) {
                        this.checkBannedTypedefWithSameName(interfaceType, scope, clazz);
                    }
                }
            } else {
                this.checkTypeAlias(namedElement, namedElement);
            }
            return true;
        }

        private void checkBannedTypedefWithSameName(DataType extendedType, RfNamedElement scope, RfClass hitElement) {
            if (extendedType == null || scope == null) {
                return;
            }
            Set<RfTypeAlias> resolvedBannedTypedefs = this.resolveTypedefs(scope);
            for (RfTypeAlias resolvedTypedef : resolvedBannedTypedefs) {
                if (!resolvedTypedef.getName().equals(extendedType.getType())) continue;
                RfAssociatedTypeWrapper resolvedDataTypeWrapper = new RfAssociatedTypeWrapper(extendedType, scope);
                this.checkTypeAlias(resolvedDataTypeWrapper, hitElement);
            }
        }

        private Set<RfTypeAlias> resolveTypedefs(RfNamedElement scope) {
            HashSet<RfTypeAlias> resolvedBannedTypedefs = new HashSet<RfTypeAlias>();
            for (String bannedTypedef : Check_R_1311.this.pBannedTypedefs) {
                IRfNamedElement typeAlias;
                String[] parts = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)bannedTypedef);
                if (parts == null || parts.length == 0 || !((typeAlias = scope.getTypeWithPrefix(parts[parts.length - 1], 1)) instanceof RfTypeAlias)) continue;
                resolvedBannedTypedefs.add((RfTypeAlias)typeAlias);
            }
            return resolvedBannedTypedefs;
        }

        private RfNamedElement getElementType(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfAssociatedType)) {
                return namedElement;
            }
            IRfNamedElement elementType = ((RfAssociatedType)namedElement).getAssociatedType();
            while (elementType instanceof RfListType) {
                elementType = ((RfListType)elementType).getAssociatedType();
            }
            if (!(elementType instanceof RfNamedElement)) {
                return namedElement;
            }
            RfNamedElement assocType = (RfNamedElement)elementType;
            return assocType;
        }

        private void checkTypeAlias(RfNamedElement namedElement, RfNamedElement hitElement) {
            RfNamedElement assocType = this.getElementType(namedElement);
            if (!(assocType instanceof RfTypeAlias)) {
                return;
            }
            String typedefFullName = assocType.getFullName();
            if (!Check_R_1311.this.pBannedTypedefs.contains(typedefFullName)) {
                return;
            }
            Check_R_1311.this.addHit(hitElement, "Banned typedef '" + typedefFullName + "'!");
        }
    }
}

