/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.2")
@CheckID(value="R.1312")
@CheckName(value="R.1312")
@CheckLabel(labels={RuleLabel.ASSIGNMENT})
@CheckTitle(value="Do not use hierarchical identifiers in net alias statements")
@CheckDescription(value="This check flags the usage of hierarchical identifiers in net alias statements.\n\nExample:\n\nalias i = foo.goo;    // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1312
extends OVMComplianceCheck {
    public Check_R_1312(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new AssignmentVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class AssignmentVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        private AssignmentVisitor() {
        }

        public boolean visit(RfHidOperator hidObject) {
            if (!hidObject.hasOccurrence(HidOperatorQualifier.IS_ALIAS)) {
                return true;
            }
            Check_R_1312.this.notifyCheckAlive();
            if (Check_R_1312.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            ListContainer rhValues = hidObject.getRHValues();
            for (IHidObject rhValue : rhValues) {
                Hid parentHid;
                RfHid hid;
                HidAccess parentAccess;
                if (rhValue instanceof RfHidAccess) {
                    RfHidAccess hidAccess = (RfHidAccess)rhValue;
                    rhValue = hidAccess.getParentHid();
                }
                if (!(rhValue instanceof RfHid) || (parentAccess = (hid = (RfHid)rhValue).getParentAccess()) == null || parentAccess.getAccessKind() != 0 || (parentHid = parentAccess.getParentHid()) == null) continue;
                Check_R_1312.this.addHit(this.parserPath, hid, "Avoid hierarchical access '" + LintUtils.getHierarchicalPath(hid) + "'!");
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

