/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.3")
@CheckID(value="R.1314")
@CheckName(value="R.1314")
@CheckLabel(labels={RuleLabel.AGENT, RuleLabel.SCOREBOARD, RuleLabel.ANALYSIS_PORT, RuleLabel.ENVIRONMENT, RuleLabel.COVERAGE, RuleLabel.VERIFICATION})
@CheckTitle(value="Connect agents to scoreboards and coverage collectors using analysis ports and exports")
@CheckDescription(value="An agent must send transactions to the rest of the environment only with analysis ports or exports.\nAny agent connection to a scoreboard or coverage collector not using such ports will be flagged.\n\nExample:\n  m_agent.get_export.connect(m_scoreboard.port);       // NOT ALLOWED\n  m_agent.analysis_port.connect(m_scoreboard.port);    // ALLOWED\n\nCheck supports pre-waiving.")
public class Check_R_1314
extends OVMComplianceCheck {
    public Check_R_1314(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String portBaseClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base");
        final String analysisPrefix = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_analysis_");
        final RfClass portBaseClass = this.fOVMProject.getRfProject().getClass(portBaseClassName, true);
        if (portBaseClass == null || this.fOVMProject.fOvmAgent == null || this.fOVMProject.fOvmComponent == null || this.fOVMProject.fOvmScoreboard == null) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                if (Check_R_1314.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1314.this.notifyCheckAlive();
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)element;
                if (!"connect".equals(function.getName())) {
                    return true;
                }
                Hid parentHid = hid.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                IRfNamedElement parentElement = parentHid.getElement();
                if (!(parentElement instanceof RfField)) {
                    return true;
                }
                RfField field = (RfField)parentElement;
                RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldType == null) {
                    return true;
                }
                if (!LintUtils.isSubClassOf(fieldType, portBaseClass)) {
                    return true;
                }
                if (fieldType.getName().startsWith(analysisPrefix)) {
                    return true;
                }
                RfNamedElement fieldScope = field.getEnclosingScope();
                if (!(fieldScope instanceof RfClass)) {
                    return true;
                }
                RfClass fieldClass = (RfClass)fieldScope;
                if (!LintUtils.isSubClassOf(fieldClass, ((Check_R_1314)Check_R_1314.this).fOVMProject.fOvmAgent)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                block0: for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) continue;
                    for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                        IRfScopeElement portScope;
                        RfField portField;
                        RfClass portType;
                        RfHid valueHid;
                        IRfNamedElement portElement;
                        IHidObject value;
                        RfField providerField;
                        IRfNamedElement key = (IRfNamedElement)entry.getKey();
                        if (!(key instanceof RfField) || !(providerField = (RfField)key).getName().equals("provider") || !((value = (IHidObject)entry.getValue()) instanceof RfHid) || !((portElement = (valueHid = (RfHid)value).getElement()) instanceof RfField) || (portType = LintUtils.getFieldFinalClassTypeOrNull(portField = (RfField)portElement)) == null || !LintUtils.isSubClassOf(portType, portBaseClass) || (portScope = portElement.getEnclosingScope()) == null || !this.isScoreboard(portScope) && !this.isCollector(portScope)) continue;
                        Check_R_1314.this.addHit(this.parserPath, hid, "Banned agent port connection for '" + LintUtils.getNamedElementFullName(field) + "'!");
                        continue block0;
                    }
                }
                return true;
            }

            private boolean isCollector(IRfScopeElement element) {
                if (!(element instanceof RfClass)) {
                    return false;
                }
                RfClass elementType = (RfClass)element;
                if (!LintUtils.isSubClassOf(elementType, ((Check_R_1314)Check_R_1314.this).fOVMProject.fOvmComponent)) {
                    return false;
                }
                List<RfCovergroup> covergroups = elementType.getCovergroupsWithPrefix("", 2, 1);
                return covergroups != null && !covergroups.isEmpty();
            }

            private boolean isScoreboard(IRfScopeElement element) {
                if (!(element instanceof RfClass)) {
                    return false;
                }
                RfClass elementType = (RfClass)element;
                return LintUtils.isSubClassOf(elementType, ((Check_R_1314)Check_R_1314.this).fOVMProject.fOvmScoreboard);
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

