/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.3")
@CheckID(value="R.1315")
@CheckName(value="R.1315")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.FIELD, RuleLabel.SUPER, RuleLabel.DECLARATION_ASSIGN})
@CheckTitle(value="Do not call super.new with fields initialized upon declaration")
@CheckDescription(value="This check flags local or inherited fields that are initialized upon declaration and passed as arguments to the super.new call.\nThese fields have an undefined value when they are passed to the super.new method call which can lead to unexpected behavior.\n\nExamples:\n\nclass b extends a;\n  int foo = 10;\n  function new;\n    super.new(foo); // not allowed\n  endfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1315
extends OVMComplianceCheck {
    public Check_R_1315(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass clazz : this.fOVMProject.getAllClasses()) {
            if (this.checkPreWaivers(clazz.getFile()) || clazz.getParent() == null) continue;
            this.notifyCheckAlive();
            RfFunction constructor = clazz.getConstructorWithPrefix("new", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            constructor.visitHidObject(null, new ConstructorVisitor(clazz));
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private final class ConstructorVisitor
    extends RfHidVisitor {
        private RfClass clazz;

        public ConstructorVisitor(RfClass clazz) {
            this.clazz = clazz;
        }

        public boolean visit(RfHid rfHid) {
            if (!(rfHid.getElement() instanceof RfFunction)) {
                return true;
            }
            if (!rfHid.getName().equals("new")) {
                return true;
            }
            if (rfHid.getParentHid() == null) {
                return true;
            }
            if (!rfHid.getParentHid().getName().equals("super")) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) continue;
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    IHidObject argumentRaw = (IHidObject)entry.getValue();
                    Set hidsFlatten = HidUtils.flattenToHids((IHidObject)argumentRaw, (Set)HidFlatteningOption.FSM_ONLY_HIDS);
                    for (IHid hid : hidsFlatten) {
                        if (hid instanceof RfHidAccess) {
                            hid = ((RfHidAccess)argumentRaw).getParentHid();
                        }
                        if (!(hid instanceof RfHid)) continue;
                        RfHid argumentHid = (RfHid)hid;
                        if (argumentHid.getAncestorHid() instanceof RfHid) {
                            argumentHid = (RfHid)argumentHid.getAncestorHid();
                        }
                        if (!(argumentHid.getElement() instanceof RfField)) continue;
                        RfField field = (RfField)argumentHid.getElement();
                        RfClass enclosingClass = field.getEnclosingScope(RfClass.class);
                        if (!field.isField()) continue;
                        if (!LintUtils.isSubClassOf(this.clazz, enclosingClass)) {
                            return true;
                        }
                        if (field.getInitialValue(false) == null) continue;
                        Check_R_1315.this.addHit(this.parserPath, rfHid, "Super.new called with " + (this.clazz.equals(enclosingClass) ? "local" : "inherited") + " field initialized upon declaration: '" + LintUtils.getNamedElementFullName(field) + "'!");
                    }
                }
            }
            return true;
        }
    }
}

