/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;

@CheckVersion(value="24.1.4")
@CheckID(value="R.1316")
@CheckName(value="R.1316")
@CheckLabel(labels={RuleLabel.BASE_CLASS, RuleLabel.VIRTUAL_SEQUENCER, RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.VERIFICATION})
@CheckTitle(value="Virtual sequencer base class name pattern")
@CheckDescription(value="This rule checks that classes matching the <namePattern> parameter extend the xvm_sequencer base class typed to the xvm_sequence_item class.\n\nCheck supports pre-waiving.")
public class Check_R_1316
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".*_virtual_sequencer", description="All classes matching this pattern are considered virtual sequencer classes.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    protected Pattern pNamePattern;
    private RfClass sequencerBaseClass;
    private RfClass baseSequencerItemClass;

    public Check_R_1316(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String sequencerBaseClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequencer");
        this.sequencerBaseClass = this.fOVMProject.getRfProject().getClass(sequencerBaseClassName, true);
        if (this.sequencerBaseClass == null) {
            return;
        }
        String baseSequencerItemClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequence_item");
        this.baseSequencerItemClass = this.fOVMProject.getRfProject().getClass(baseSequencerItemClassName, true);
        if (this.baseSequencerItemClass == null) {
            return;
        }
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(clazz.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            if (!this.pNamePattern.matcher(clazz.getName()).matches()) continue;
            this.checkVirtualSequencer((RfClass)clazz);
        }
    }

    private void checkVirtualSequencer(RfClass sequence) {
        sequence = sequence.getDefaultSpecialization(null);
        RfClass parentClass = sequence.getParent();
        while (parentClass != null) {
            if (parentClass instanceof RfSpecializedClass && this.sequencerBaseClass.equals(((RfSpecializedClass)parentClass).getGenericClass())) break;
            parentClass = parentClass.getParent();
        }
        if (!(parentClass instanceof RfSpecializedClass)) {
            this.addHit(sequence, "Class '" + LintUtils.getNamedElementFullName(sequence) + "' must extend '" + LintUtils.getNamedElementFullName(this.sequencerBaseClass) + "' class!");
            return;
        }
        Map<String, IELParamValue> params = ((RfSpecializedClass)parentClass).getLocalElabConstantValues();
        if (params.isEmpty()) {
            return;
        }
        Boolean hasOnlyBaseSequencerItemParams = true;
        for (Map.Entry<String, IELParamValue> entry : params.entrySet()) {
            if (!(entry.getValue() instanceof ELParamValues.ParamValueType)) {
                hasOnlyBaseSequencerItemParams = false;
                break;
            }
            ELParamValues.ParamValueType paramValue = (ELParamValues.ParamValueType)entry.getValue();
            if (!(paramValue.getNamedElement() instanceof RfClass)) {
                hasOnlyBaseSequencerItemParams = false;
                break;
            }
            RfClass paramClass = (RfClass)paramValue.getNamedElement();
            if (paramClass.equals(this.baseSequencerItemClass) || paramClass.getGenericClass().equals(this.baseSequencerItemClass)) continue;
            hasOnlyBaseSequencerItemParams = false;
            break;
        }
        if (!hasOnlyBaseSequencerItemParams.booleanValue()) {
            this.addHit(sequence, "Class '" + LintUtils.getNamedElementFullName(sequence) + "' must have '" + LintUtils.getNamedElementFullName(this.baseSequencerItemClass) + "' as the parameter for the '" + LintUtils.getNamedElementFullName(this.sequencerBaseClass) + "' base class!");
        }
    }
}

