/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.4")
@CheckID(value="R.1317")
@CheckName(value="R.1317")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.CONDITIONAL, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Use maximum one relational operation in a conditional expression")
@CheckDescription(value="For example, to make the whole expression a==b==c true, c will have to be equal to the result of a==b, and not to be equal to a and equal to b. This means that c will always be either 0 or 1, as the result of a==b is either 0 or 1.\nThe check fails even if parentheses are used because this does not guarantee the intention of the code is to actually do such a comparison.\n\nExamples:\nif (a == b == c)       // not allowed\nif (a == (b == c))     // not allowed\nif (a == b && b == c)  // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1317
extends OVMComplianceCheck {
    public Check_R_1317(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new OperatorVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class OperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        OperatorVisitor() {
        }

        public boolean visit(RfHidOperator operator) {
            if (!operator.isConditionalTernary() && !operator.isActionBlockCondition()) {
                return true;
            }
            IHidObject condition = operator.getLHValue();
            if (operator.isCaseItemCondition()) {
                condition = operator.getFirstRHValue();
            }
            if (!(condition instanceof RfHidOperator)) {
                return true;
            }
            if (Check_R_1317.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1317.this.notifyCheckAlive();
            this.checkForRelationalOperators(condition);
            return true;
        }

        private void checkForRelationalOperators(IHidObject hidObject) {
            if (!(hidObject instanceof RfHidOperator)) {
                return;
            }
            RfHidOperator conditionOperator = (RfHidOperator)hidObject;
            List rhValues = OptimizedUtils.asList((ListContainer)conditionOperator.getRHValues(), (boolean)false);
            IHidObject lhValue = conditionOperator.getLHValue();
            if (rhValues != null && rhValues.size() > 1) {
                return;
            }
            if (!this.isRelationalOperator(conditionOperator)) {
                this.checkForRelationalOperators(lhValue);
                if (rhValues == null) {
                    return;
                }
                this.checkForRelationalOperators((IHidObject)rhValues.get(0));
                return;
            }
            ArrayList<IHidObject> hidValues = new ArrayList<IHidObject>();
            if (rhValues != null && !rhValues.isEmpty()) {
                hidValues.addAll(rhValues);
            }
            if (lhValue != null) {
                hidValues.add(lhValue);
            }
            for (IHidObject hid : hidValues) {
                if (!(hid instanceof RfHidOperator) || !this.isRelationalOperator((RfHidOperator)hid)) continue;
                Check_R_1317.this.addHit(this.parserPath, (HidOccurrence)conditionOperator.getOccurrence(), "Conditional expression '" + conditionOperator + "' has more than one relational operator!");
            }
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }

        private boolean isRelationalOperator(RfHidOperator op) {
            return op.isRelational() || op.isEqualityOrInequality() || op.isWildcardEquality();
        }
    }
}

