/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractMultipleOperandsWidthMissmatchCheck;
import ro.amiq.vlogdt.linter.rules.AbstractWidthMissmatchCheck;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.11")
@CheckID(value="R.1318")
@CheckName(value="R.1318")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.WIDTH_MISMATCH, RuleLabel.COMPARISON})
@CheckTitle(value="Do not compare different width elements")
@CheckDescription(value="This check verifies that comparisons do not use elements of different widths.\nInt parameters are not flagged if the width of the field it is compared against can represent its actual value.\n\nExamples:\n\nint my_var1, my_var2;\nbit [2:0] array;\nbit [5:0] my_array;\n\nif (array < my_array)                     // not allowed\nif (array < 2'b10) \t                    // allowed iff skipComparisonsWithImplicits is true\nif (array < my_var1 + 1) \t                // allowed iff ignoreIntTypeVariables is true\nif (my_array ** my_array < my_var1 + 1) \t// allowed because right-hand side contains only implicits and int types, and fits within the left-hand side size\nif (my_var1 + 1 < my_var2 + 2) \t        // allowed because comparison contains only implicits and int types\n\nCheck supports pre-waiving.")
public class Check_R_1318
extends AbstractMultipleOperandsWidthMissmatchCheck {
    @CheckParameter(defaultValue="false", description="If true, the check skips comparisons with implicits. Default value: false", name="skipComparisonsWithImplicits", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipComparisonsWithImplicits;
    private static final Set<Integer> OPERATOR_TYPE_TOKENS = new HashSet<Integer>(Arrays.asList(482, 483, 484, 485, 502, 504, 486, 487, 488, 489));

    public Check_R_1318(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        if (this.fOVMProject == null) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(null, new ArithmeticComparisonVisitor());
    }

    @Override
    protected Collection<IHidObject> flattenToHidsFromOperator(RfHidOperator operator) {
        ArrayList<IHidObject> flattenedHids = new ArrayList<IHidObject>();
        Set flattenOP = HidUtils.flattenToOperators((IHidOperator)operator);
        for (IHidOperator op : flattenOP) {
            if (!(op instanceof RfHidOperator)) {
                return null;
            }
            operator = (RfHidOperator)op;
            if (!(operator.getLHValue() instanceof RfHidOperator) && !operator.isVLOGConcatenation(true)) {
                flattenedHids.add(operator.getLHValue());
            }
            if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR && !operator.isVLOGConcatenation(true)) continue;
            if (operator.getRHValues() == null) {
                return null;
            }
            for (IHidObject operand : operator.getRHValues()) {
                if (operand instanceof RfHidOperator) continue;
                flattenedHids.add(operand);
            }
        }
        return flattenedHids;
    }

    @Override
    protected boolean checkOperatorsInRHSide(RfHidOperator operator) {
        return operator.isVLOGConcatenation(true) || operator.isPlus() || operator.isMinus() || operator.isStar() || operator.isDiv() || operator.isBinaryBitwise();
    }

    public void checkSizes(List<IHidObject> nonImplicitsInRightHSide, List<IHidObject> nonImplicitsInLeftHSide, List<RfHidImplicit> implicitsInRightHSide, List<RfHidImplicit> implicitsInLeftHSide, IHidObject rhHidObject, IHidObject lhHidObject, Integer indexOfFirstRhHid, RfHidOperator operator, Map<IHidObject, String> pathsText, ParserPath parserPath, boolean hasPathsText, List<IHidObject> hidObjects, List<IRfNamedElement> elements, List<RfNamedElement> elementTypes, List<ELParamValuesHidEvaluator> hidEvaluators, ELSpecializationWrapper specsWrapper, IRfNamedElement scope) {
        Boolean lhAllIntOrImplicits = this.checkAllIntOrImplicit(0, indexOfFirstRhHid, nonImplicitsInLeftHSide, implicitsInLeftHSide, hidObjects, elementTypes);
        if (lhAllIntOrImplicits == null) {
            return;
        }
        int[] lhOpSize = this.checkSizeEachPart(0, indexOfFirstRhHid, nonImplicitsInLeftHSide, implicitsInLeftHSide, lhHidObject, hidObjects, elements, elementTypes, hidEvaluators, specsWrapper, scope);
        if (lhOpSize == null || lhOpSize.length == 0) {
            return;
        }
        if (this.pIgnoreIntTypeVariables && lhAllIntOrImplicits.booleanValue()) {
            return;
        }
        Boolean rhAllIntOrImplicits = this.checkAllIntOrImplicit(indexOfFirstRhHid, hidObjects.size(), nonImplicitsInRightHSide, implicitsInRightHSide, hidObjects, elementTypes);
        if (rhAllIntOrImplicits == null) {
            return;
        }
        int[] rhOpSize = this.checkSizeEachPart(indexOfFirstRhHid, hidObjects.size(), nonImplicitsInRightHSide, implicitsInRightHSide, rhHidObject, hidObjects, elements, elementTypes, hidEvaluators, specsWrapper, scope);
        if (rhOpSize == null || rhOpSize.length == 0) {
            return;
        }
        if (this.pIgnoreIntTypeVariables && rhAllIntOrImplicits.booleanValue()) {
            return;
        }
        if (this.checkForIntComparison(rhAllIntOrImplicits, lhAllIntOrImplicits, rhOpSize, lhOpSize, operator, pathsText, parserPath, hasPathsText)) {
            return;
        }
        if (!Arrays.equals(rhOpSize, lhOpSize)) {
            this.addLocalHit(parserPath, operator, pathsText, hasPathsText, lhOpSize, rhOpSize);
        }
    }

    private Boolean checkAllIntOrImplicit(Integer idx, Integer lastIdx, List<IHidObject> nonImplicits, List<RfHidImplicit> implicits, List<IHidObject> hidObjects, List<RfNamedElement> elementTypes) {
        int nrOfInt = 0;
        boolean allIntOrImplicits = false;
        if (this.pSkipComparisonsWithImplicits && nonImplicits.isEmpty() && !implicits.isEmpty()) {
            return null;
        }
        int index = idx;
        while (index < lastIdx) {
            if (hidObjects.get(index) instanceof RfHid && "int".equals(elementTypes.get(index).getName())) {
                ++nrOfInt;
            }
            ++index;
        }
        if (nrOfInt > 0 && nrOfInt == nonImplicits.size()) {
            allIntOrImplicits = true;
        }
        return allIntOrImplicits;
    }

    private int[] checkSizeEachPart(Integer idx, Integer lastIdx, List<IHidObject> nonImplicits, List<RfHidImplicit> implicits, IHidObject comparisonOperandPartHidObject, List<IHidObject> hidObjects, List<IRfNamedElement> elements, List<RfNamedElement> elementTypes, List<ELParamValuesHidEvaluator> hidEvaluators, ELSpecializationWrapper specsWrapper, IRfNamedElement scope) {
        HashMap<IHidObject, int[]> fieldDimensionsForHid = new HashMap<IHidObject, int[]>();
        for (RfHidImplicit implicit : implicits) {
            this.calculateSizeOfImplicit(implicit, fieldDimensionsForHid, scope);
        }
        ArrayList<int[]> fieldDimensionsInfo = new ArrayList<int[]>();
        int index = idx;
        while (index < lastIdx) {
            fieldDimensionsInfo.add(this.getSizeOfHid(hidObjects.get(index), elements.get(index), elementTypes.get(index), hidEvaluators.get(index), specsWrapper, scope));
            ++index;
        }
        if (fieldDimensionsInfo.contains(null)) {
            return null;
        }
        List fieldDimensionsInfoExpanded = fieldDimensionsInfo.stream().map(dimensions -> {
            int[] nArray;
            if (((int[])dimensions).length == 1) {
                int[] nArray2 = new int[2];
                nArray = nArray2;
                nArray2[0] = this.getNumberOfBitsUsedInInteger(dimensions[0]) - 1;
            } else {
                nArray = dimensions;
            }
            return nArray;
        }).collect(Collectors.toList());
        int maxNrOfDimensions = fieldDimensionsInfoExpanded.stream().mapToInt(fieldDimensions -> ((int[])fieldDimensions).length).max().orElse(0);
        fieldDimensionsInfoExpanded = fieldDimensionsInfoExpanded.stream().map(arr -> ((int[])arr).length == maxNrOfDimensions ? arr : Arrays.copyOf(arr, maxNrOfDimensions)).collect(Collectors.toList());
        int i = 0;
        while (i < nonImplicits.size()) {
            fieldDimensionsForHid.put(nonImplicits.get(i), (int[])fieldDimensionsInfoExpanded.get(i));
            ++i;
        }
        return this.calculateSizeOfHid(comparisonOperandPartHidObject, fieldDimensionsForHid);
    }

    private boolean checkForIntComparison(boolean rhAllIntOrImplicits, boolean lhAllIntOrImplicits, int[] rhOpSize, int[] lhOpSize, RfHidOperator operator, Map<IHidObject, String> pathsText, ParserPath parserPath, boolean hasPathsText) {
        if (rhAllIntOrImplicits && lhAllIntOrImplicits) {
            return true;
        }
        if (rhAllIntOrImplicits) {
            int rhSize = this.sizeOfOperation(rhOpSize);
            int lhSize = this.sizeOfOperation(lhOpSize);
            if (lhSize == 0) {
                return true;
            }
            if (rhSize > lhSize) {
                this.addLocalHit(parserPath, operator, pathsText, hasPathsText, lhOpSize, rhOpSize);
            }
            return true;
        }
        if (lhAllIntOrImplicits) {
            int lhSize = this.sizeOfOperation(lhOpSize);
            int rhSize = this.sizeOfOperation(rhOpSize);
            if (rhSize == 0) {
                return true;
            }
            if (lhSize > rhSize) {
                this.addLocalHit(parserPath, operator, pathsText, hasPathsText, lhOpSize, rhOpSize);
            }
            return true;
        }
        return false;
    }

    private int sizeOfOperation(int[] opSizeArr) {
        int opSize = 0;
        int i = 0;
        while (i < opSizeArr.length) {
            opSize += Math.abs(opSizeArr[i] - opSizeArr[i + 1]) + 1;
            i += 2;
        }
        return opSize;
    }

    @Override
    public boolean checkOperator(RfHidOperator operator) {
        int operatorType = operator.getOperatorType();
        return (OPERATOR_TYPE_TOKENS.contains(operatorType) || operator.isCaseItemCondition()) && !operator.isAssignment();
    }

    @Override
    public String getHitMessageKind() {
        return "Width mismatch on comparison";
    }

    private void addLocalHit(ParserPath parserPath, RfHidOperator operator, Map<IHidObject, String> pathsText, boolean hasPathsText, int[] lhSize, int[] rhSize) {
        StringBuilder hitMessage = new StringBuilder("");
        hitMessage.append("Width missmatch in comparison " + HidUtils.toNiceString((IHidObject)operator) + "!\nLeft hand operand has width " + this.getWidthAsString(lhSize) + ", while right hand operand has width " + this.getWidthAsString(rhSize));
        if (hasPathsText) {
            hitMessage.append("\n\nHierarchy Paths for:");
            for (Map.Entry<IHidObject, String> pathsEntry : pathsText.entrySet()) {
                hitMessage.append("\n  '").append(HidUtils.toNiceString((IHidObject)pathsEntry.getKey())).append("': ").append(pathsEntry.getValue());
            }
        }
        this.addHit(parserPath, (HidOccurrence)operator.getOccurrence(), hitMessage.toString());
    }

    private class ArithmeticComparisonVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private IRfNamedElement scope;

        private ArithmeticComparisonVisitor() {
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public boolean visit(RfHidOperator operator) {
            Collection<IHidObject> flattenedLhHids;
            Collection<IHidObject> flattenedRhHids;
            if (!Check_R_1318.this.checkOperator(operator)) {
                return true;
            }
            if (Check_R_1318.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1318.this.notifyCheckAlive();
            IHidObject lhHidObject = operator.getLHValue();
            IHidObject rhHidObject = operator.getFirstRHValue();
            if (lhHidObject == null || rhHidObject == null) {
                return true;
            }
            if (rhHidObject instanceof RfHidImplicit && "default".equals(((RfHidImplicit)rhHidObject).getName())) {
                return true;
            }
            if (lhHidObject instanceof RfHidAccessArgs && ((RfHidAccessArgs)lhHidObject).getSelects() != null) {
                return true;
            }
            if (rhHidObject instanceof RfHidAccessArgs && ((RfHidAccessArgs)rhHidObject).getSelects() != null) {
                return true;
            }
            if (rhHidObject instanceof RfHidOperator) {
                flattenedRhHids = Check_R_1318.this.flattenToHidsFromOperator((RfHidOperator)rhHidObject);
                if (flattenedRhHids == null) {
                    return true;
                }
            } else {
                flattenedRhHids = Arrays.asList(rhHidObject);
            }
            List<RfHidImplicit> implicitsInRightHSide = flattenedRhHids.stream().filter(hid -> hid instanceof RfHidImplicit && !((RfHidImplicit)hid).isStringLiteral()).map(RfHidImplicit.class::cast).collect(Collectors.toList());
            List<IHidObject> nonImplicitsInRightHSide = flattenedRhHids.stream().filter(hid -> !(hid instanceof RfHidImplicit)).collect(Collectors.toList());
            if (lhHidObject instanceof RfHidOperator) {
                flattenedLhHids = Check_R_1318.this.flattenToHidsFromOperator((RfHidOperator)lhHidObject);
                if (flattenedLhHids == null) {
                    return true;
                }
            } else {
                flattenedLhHids = Arrays.asList(lhHidObject);
            }
            List<RfHidImplicit> implicitsInLeftHSide = flattenedLhHids.stream().filter(hid -> hid instanceof RfHidImplicit && !((RfHidImplicit)hid).isStringLiteral()).map(RfHidImplicit.class::cast).collect(Collectors.toList());
            List<IHidObject> nonImplicitsInLeftHSide = flattenedLhHids.stream().filter(hid -> !(hid instanceof RfHidImplicit)).collect(Collectors.toList());
            ArrayList<IHidObject> hidObjects = new ArrayList<IHidObject>();
            ArrayList<RfHid> valueRfHids = new ArrayList<RfHid>();
            ArrayList<IRfNamedElement> elements = new ArrayList<IRfNamedElement>();
            ArrayList<RfNamedElement> elementTypes = new ArrayList<RfNamedElement>();
            ArrayList<IRfNamedElement> ancestorElements = new ArrayList<IRfNamedElement>();
            ArrayList<Hid> instanceHids = new ArrayList<Hid>();
            ArrayList<IRfNamedElement> instanceFieldOrFunctions = new ArrayList<IRfNamedElement>();
            ArrayList<IRfScopeElement> ancestorElementEnclosingScopes = new ArrayList<IRfScopeElement>();
            ArrayList<IRfScopeElement> elementEnclosingScopes = new ArrayList<IRfScopeElement>();
            ArrayList<Boolean> isElementTypeParameter = new ArrayList<Boolean>();
            for (IHidObject lhHid : nonImplicitsInLeftHSide) {
                if (Check_R_1318.this.checkHidAndPopulateArrays(lhHid, hidObjects, valueRfHids, elements, elementTypes, instanceHids, ancestorElements, instanceFieldOrFunctions, ancestorElementEnclosingScopes, elementEnclosingScopes, isElementTypeParameter)) continue;
                return true;
            }
            for (IHidObject rhHid : nonImplicitsInRightHSide) {
                if (Check_R_1318.this.checkHidAndPopulateArrays(rhHid, hidObjects, valueRfHids, elements, elementTypes, instanceHids, ancestorElements, instanceFieldOrFunctions, ancestorElementEnclosingScopes, elementEnclosingScopes, isElementTypeParameter)) continue;
                return true;
            }
            Integer indexOfFirstRhHid = nonImplicitsInLeftHSide.size();
            ArrayList<ELParamValuesHidEvaluator> hidEvaluators = new ArrayList<ELParamValuesHidEvaluator>();
            HashMap<IHidObject, String> pathsText = new HashMap<IHidObject, String>();
            if (ancestorElementEnclosingScopes.contains(null) || elementEnclosingScopes.contains(null) || ancestorElementEnclosingScopes.stream().anyMatch(ancestorElement -> Check_R_1318.this.specsPerElement.get(ancestorElement) == null) || ancestorElementEnclosingScopes.stream().distinct().count() != 1L || IntStream.range(0, elements.size()).allMatch(index -> !Check_R_1318.this.shouldEvaluateWithNonEmptyEvaluator((IRfNamedElement)elements.get(index), (IRfNamedElement)elementTypes.get(index), true))) {
                elements.forEach(element -> {
                    boolean bl = hidEvaluators.add(Check_R_1318.this.emptyEvaluator);
                });
                Check_R_1318.this.checkSizes(nonImplicitsInRightHSide, nonImplicitsInLeftHSide, implicitsInRightHSide, implicitsInLeftHSide, rhHidObject, lhHidObject, indexOfFirstRhHid, operator, pathsText, this.parserPath, false, hidObjects, elements, elementTypes, hidEvaluators, null, this.scope);
                return true;
            }
            Map specializationWrappers = (Map)Check_R_1318.this.specsPerElement.get(ancestorElementEnclosingScopes.get(0));
            block2: for (ELSpecializationWrapper ancestorFieldWrapper : specializationWrappers.values()) {
                hidEvaluators.clear();
                pathsText.clear();
                IHidEvaluator defaultEvaluator = ancestorFieldWrapper.getHidEvaluator(Check_R_1318.this.elManager);
                if (!(defaultEvaluator instanceof ELParamValuesHidEvaluator) || ancestorFieldWrapper.paths == null) continue;
                int index2 = 0;
                while (index2 < elementEnclosingScopes.size()) {
                    Map fieldSpecializationWrappers = (Map)Check_R_1318.this.specsPerElement.get(elementEnclosingScopes.get(index2));
                    AbstractWidthMissmatchCheck.SpecInfo specInfo = Check_R_1318.this.getWrapperForInstance((Hid)instanceHids.get(index2), (IRfNamedElement)instanceFieldOrFunctions.get(index2), fieldSpecializationWrappers, defaultEvaluator, ancestorFieldWrapper.paths);
                    IHidEvaluator fieldSpecializationEvaluator = specInfo.getEvaluator();
                    if (!(fieldSpecializationEvaluator instanceof ELParamValuesHidEvaluator)) continue block2;
                    hidEvaluators.add((ELParamValuesHidEvaluator)fieldSpecializationEvaluator);
                    String pathText = specInfo.getPath() == null ? ancestorFieldWrapper.getPathsText() : specInfo.getPath();
                    pathsText.put((IHidObject)hidObjects.get(index2), pathText);
                    ++index2;
                }
                Check_R_1318.this.checkSizes(nonImplicitsInRightHSide, nonImplicitsInLeftHSide, implicitsInRightHSide, implicitsInLeftHSide, rhHidObject, lhHidObject, indexOfFirstRhHid, operator, pathsText, this.parserPath, true, hidObjects, elements, elementTypes, hidEvaluators, ancestorFieldWrapper, this.scope);
                if (IntStream.range(0, elements.size()).allMatch(index -> !Check_R_1318.this.shouldEvaluateWithNonEmptyEvaluator((IRfNamedElement)elements.get(index), (IRfNamedElement)elementTypes.get(index), true))) break;
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

