/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractOverrideMethodCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.10")
@CheckID(value="R.1319")
@CheckName(value="R.1319")
@CheckLabel(labels={RuleLabel.COVERAGE, RuleLabel.CLASS_INSTANTIATION, RuleLabel.CONDITIONAL, RuleLabel.COVERGROUP, RuleLabel.VERIFICATION})
@CheckTitle(value="Coverage collector classes should be instantiated in conditional blocks")
@CheckDescription(value="This rule checks that classes that contain covergroup declarations are instantiated inside a conditional block.\n\nExamples:\ncg_class instance;\n\nif (coverage_enable)\n\tinstance = cg_class::type_id::create(\"cg_class\", ,get_full_name()) // ALLOWED\n\ninstance = new(\"cg_class\") // NOT ALLOWED\ninstance = cg_class::type_id::create(\"cg_class\", ,get_full_name()) // NOT ALLOWED\n\nCheck supports pre-waiving.")
public class Check_R_1319
extends AbstractOverrideMethodCheck {
    private Set<RfClass> classesWithCovergroup;
    private RfClass xvmObjectRegistryClass;
    private RfFunction xvmObjectRegistryCreateMethod;
    private RfClass xvmComponentRegistryClass;
    private RfFunction xvmComponentRegistryCreateMethod;

    public Check_R_1319(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.classesWithCovergroup = new HashSet<RfClass>();
        RfPackage xvmPackage = this.getXVMPackage();
        if (xvmPackage != null) {
            this.xvmObjectRegistryClass = this.getXVMClass(xvmPackage, "_object_registry");
            this.xvmComponentRegistryClass = this.getXVMClass(xvmPackage, "_component_registry");
            if (this.xvmObjectRegistryClass == null || this.xvmComponentRegistryClass == null) {
                return;
            }
            this.xvmObjectRegistryCreateMethod = this.getXVMFunction(this.xvmObjectRegistryClass, "create");
            this.xvmComponentRegistryCreateMethod = this.getXVMFunction(this.xvmComponentRegistryClass, "create");
        }
        for (RfNamedElement elem : this.fOVMProject.getAllCovergroups()) {
            ParserPath elemParserPath;
            RfFileDef elemFile = elem.getFile();
            if (elemFile == null || (elemParserPath = elemFile.getParserPath()) == null || this.checkPreWaivers(elemParserPath)) continue;
            this.notifyCheckAlive();
            RfClass cvgScope = elem.getEnclosingScope(RfClass.class);
            if (cvgScope == null) continue;
            this.classesWithCovergroup.add(cvgScope);
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new IHidVisitor<RfHidOperator>(){
            private ParserPath parserPath;
            private IRfNamedElement scope;

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public void setScope(IRfNamedElement scope) {
                this.scope = scope;
            }

            /*
             * Unable to fully structure code
             */
            public boolean visit(RfHidOperator hidObject) {
                Check_R_1319.this.notifyCheckAlive();
                if (Check_R_1319.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (!hidObject.isAssignment()) {
                    return true;
                }
                lhValue = hidObject.getLHValue();
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                element = ((RfHid)lhValue).getElement();
                if (element == null || !(element instanceof RfField)) {
                    return true;
                }
                field = (RfField)element;
                associatedType = field.getAssociatedType();
                if (associatedType == null) {
                    return true;
                }
                if (!(associatedType instanceof RfClass)) {
                    return true;
                }
                checkedClass = (RfClass)associatedType;
                if (!Check_R_1319.this.classesWithCovergroup.contains(checkedClass.getGenericClass())) {
                    return true;
                }
                rhValues = hidObject.getRHValues();
                if (rhValues == null || rhValues.isEmpty() || !(rhValues.get(0) instanceof RfHidAccessArgs)) {
                    return true;
                }
                accessArgs = (RfHidAccessArgs)rhValues.get(0);
                parentHid = accessArgs.getParentHid();
                if (!(parentHid instanceof RfHid)) {
                    return true;
                }
                parentElement = parentHid.getElement();
                if (parentElement == null || !(parentElement instanceof RfFunction)) {
                    return true;
                }
                if (((RfFunction)parentElement).isConstructor() || ((RfFunction)parentElement).equals(Check_R_1319.this.xvmObjectRegistryCreateMethod) || ((RfFunction)parentElement).equals(Check_R_1319.this.xvmComponentRegistryCreateMethod)) ** GOTO lbl35
                return true;
                while (!(this.scope instanceof RfActionBlock) || !((RfActionBlock)this.scope).isConditional()) {
                    this.scope = (IRfNamedElement)this.scope.getEnclosingScope();
lbl35:
                    // 2 sources

                    if (this.scope != null) continue;
                }
                if (this.scope == null) {
                    Check_R_1319.access$0(Check_R_1319.this, this.parserPath, (RfHid)lhValue, "Coverage collector class: '" + LintUtils.getNamedElementFullName((RfNamedElement)associatedType) + "' instantiated outside of a conditional block!");
                }
                return true;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    static /* synthetic */ List access$0(Check_R_1319 check_R_1319, ParserPath parserPath, RfHid rfHid, String string) {
        return check_R_1319.addHit(parserPath, rfHid, string);
    }
}

