/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="24.1.11")
@CheckID(value="R.1320")
@CheckName(value="R.1320")
@CheckLabel(labels={RuleLabel.FUNCTIONAL, RuleLabel.RAL, RuleLabel.REGISTER, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not perform backdoor access right after register access via frontdoor")
@CheckDescription(value="Accessing a register via backdoor right after accessing via frontdoor without waiting for a time unit can lead to unexpected behavior.\nImplementation notes: a backdoor access is considered if the path is specifically set to 'UVM_BACKDOOR', likewise for the frontdoor access.\nIf a path is not specified, then the register access will not be considered.\nThe only exception to this rule is the 'uvm_reg::predict()' method, which performs a frontdoor access without explicitly specifying a path.\n\nExample:\n\nreg.write(status, rdata);\nreg.read(status, rdata, UVM_BACKDOOR);  // NOT ALLOWED\n\nreg.write(status, rdata);\n#1;\nreg.read(status, rdata, UVM_BACKDOOR);  // ALLOWED\n\nCheck supports pre-waiving.")
public class Check_R_1320
extends OVMComplianceCheck {
    private RfClass registerClass;
    private final Set<String> checkedFunctions = new HashSet<String>(Arrays.asList("read", "write", "mirror", "update", "predict"));

    public Check_R_1320(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.registerClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_reg"), true);
        if (this.registerClass == null) {
            return;
        }
        NullProtectedList<RfNamedElement> methods = new NullProtectedList<RfNamedElement>();
        methods.addAll(this.fOVMProject.getAllFunctions());
        methods.addAll(this.fOVMProject.getAllTasks());
        methods.forEach(method -> this.checkFunction((RfNamedElement)method));
    }

    /*
     * Unable to fully structure code
     */
    private void checkFunction(RfNamedElement function) {
        if (!(function instanceof RfFunction)) {
            return;
        }
        this.notifyCheckAlive();
        if (this.checkPreWaivers(function.getDeclaration())) {
            return;
        }
        readWriteVisitor = new LocalReadWriteVisitor();
        timeConsumingVisitor = new LocalTimeConsumingVisitor();
        function.visitHidObject(null, readWriteVisitor);
        function.visitHidObject(null, timeConsumingVisitor);
        hidToFunctionCallsOffsets = readWriteVisitor.getHidToFunctionCalls();
        timeConsumingStatements = timeConsumingVisitor.getTimeConsumingStatements();
        Collections.sort(timeConsumingStatements);
        for (Map.Entry<HidAccess, List<DVTPair<LintUtils.PathType, RfHid>>> entry : hidToFunctionCallsOffsets.entrySet()) {
            indexFunctionCalls = 0;
            indexTimeConsuming = 0;
            indexLastFrontdoorAccess = -1;
            functionCalls = entry.getValue();
            while (indexFunctionCalls < functionCalls.size()) {
                if (functionCalls.get(indexFunctionCalls).getKey() == LintUtils.PathType.FRONTDOOR) {
                    indexLastFrontdoorAccess = indexFunctionCalls;
                    indexFunctionCalls = indexFunctionCalls + 1;
                    break;
                }
                indexFunctionCalls = indexFunctionCalls + 1;
            }
            while (indexFunctionCalls < functionCalls.size()) {
                if (functionCalls.get(indexFunctionCalls).getKey() != LintUtils.PathType.FRONTDOOR) ** GOTO lbl33
                indexLastFrontdoorAccess = indexFunctionCalls;
                indexFunctionCalls = indexFunctionCalls + 1;
                continue;
lbl-1000:
                // 1 sources

                {
                    indexTimeConsuming = indexTimeConsuming + 1;
lbl33:
                    // 2 sources

                    ** while (indexTimeConsuming.intValue() < timeConsumingStatements.size() && timeConsumingStatements.get((int)indexTimeConsuming.intValue()).intValue() <= ((RfHid)functionCalls.get((int)indexLastFrontdoorAccess.intValue()).getValue()).getOffset())
                }
lbl34:
                // 1 sources

                if (indexTimeConsuming >= timeConsumingStatements.size() || timeConsumingStatements.get(indexTimeConsuming) >= ((RfHid)functionCalls.get(indexFunctionCalls).getValue()).getOffset()) {
                    this.addHit(function.getFile().getParserPath(), ((RfHid)functionCalls.get(indexFunctionCalls).getValue()).getOccurrence(), "'" + ((RfHid)functionCalls.get(indexFunctionCalls).getValue()).getName() + "'" + " backdoor access performed on " + HidUtils.toNiceString((IHidObject)entry.getKey().getParentHid()) + " right after the " + "'" + ((RfHid)functionCalls.get(indexLastFrontdoorAccess).getValue()).getName() + "'" + " frontdoor access on line: " + ((RfHid)functionCalls.get(indexLastFrontdoorAccess).getValue()).getLine() + "!");
                }
                indexFunctionCalls = indexFunctionCalls + 1;
            }
        }
    }

    private boolean checkPreWaivers(RfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(defElement.getParserPath(), this);
    }

    private final class LocalReadWriteVisitor
    implements IHidVisitor<RfHid> {
        private final Map<HidAccess, List<DVTPair<LintUtils.PathType, RfHid>>> hidToFunctionCalls = new HashMap<HidAccess, List<DVTPair<LintUtils.PathType, RfHid>>>();

        public boolean visit(RfHid hid) {
            if (!(hid.getElement() instanceof RfFunction)) {
                return true;
            }
            if (!Check_R_1320.this.checkedFunctions.contains(hid.getName())) {
                return true;
            }
            HidAccess parrentAccess = hid.getParentAccess();
            if (parrentAccess == null) {
                return true;
            }
            IRfNamedElement parrentAssociatedType = parrentAccess.getAssociatedType();
            if (!(parrentAssociatedType instanceof RfClass)) {
                return true;
            }
            if (!LintUtils.isSubClassOf((RfClass)parrentAssociatedType, Check_R_1320.this.registerClass)) {
                return true;
            }
            LintUtils.PathType accessType = LintUtils.getAccessType(hid, hid.getName());
            if (accessType == LintUtils.PathType.DEFAULT) {
                return true;
            }
            this.hidToFunctionCalls.putIfAbsent(parrentAccess, new ArrayList());
            this.hidToFunctionCalls.get(parrentAccess).add((DVTPair<LintUtils.PathType, RfHid>)new DVTPair((Object)accessType, (Object)hid));
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }

        public Map<HidAccess, List<DVTPair<LintUtils.PathType, RfHid>>> getHidToFunctionCalls() {
            return this.hidToFunctionCalls;
        }
    }

    private final class LocalTimeConsumingVisitor
    implements IHidVisitor<IHidObject> {
        private final List<Integer> timeConsumingStatementOffsets = new ArrayList<Integer>();

        private boolean isTask(IHidObject hidObject) {
            if (!(hidObject instanceof RfHidAccess)) {
                return false;
            }
            RfHidAccess hidAccess = (RfHidAccess)hidObject;
            if (!(hidAccess.getParentHid() instanceof RfHid)) {
                return false;
            }
            RfHid hid = (RfHid)hidAccess.getParentHid();
            if (!(hid.getElement() instanceof RfFunction)) {
                return false;
            }
            RfFunction function = (RfFunction)hid.getElement();
            return function.isTask();
        }

        private final boolean isDelayOrWait(IHidObject hidObject) {
            if (!(hidObject instanceof RfHidOperator)) {
                return false;
            }
            RfHidOperator hidOperator = (RfHidOperator)hidObject;
            return hidOperator.isEventControl() || hidOperator.isWaitEventControl() || hidOperator.isVlogDelayControlStatement() || hidOperator.isPoundPound();
        }

        public boolean visit(IHidObject hidObject) {
            if (this.isTask(hidObject)) {
                this.timeConsumingStatementOffsets.add(((RfHidAccess)hidObject).getOccurrence().getOffset());
            }
            if (this.isDelayOrWait(hidObject)) {
                this.timeConsumingStatementOffsets.add(((RfHidOperator)hidObject).getOffset());
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        public List<Integer> getTimeConsumingStatements() {
            return this.timeConsumingStatementOffsets;
        }
    }
}

