/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.10")
@CheckID(value="R.1321")
@CheckName(value="R.1321")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.ENUM, RuleLabel.COMPARISON})
@CheckTitle(value="Do not use comparison operators with enum elements")
@CheckDescription(value="This check flags the usage of Less Than/Greater Than operators in enum comparisons.\nSuch comparisons can be dangerous since the name of the enums do not always represent the values of the enums, and the values can change without the user knowing it.\n\nExamples:\ntypedef enum logic [1:0] {kA = 0, kB = 1} my_enum_t;\nmy_enum_t my_enum;\n\nx  = (my_enum == kA); // allowed\ny  = (my_enum != kA); // allowed\nz1 = (my_enum <  kA); // not allowed\nz2 = (my_enum <= kA); // not allowed\nz3 = (my_enum >  kA); // not allowed\nz4 = (my_enum >= kA); // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1321
extends OVMComplianceCheck {
    private static final Set<Integer> OPERATOR_TYPE_TOKENS = new HashSet<Integer>(Arrays.asList(486, 487, 488, 489));

    public Check_R_1321(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new OperatorVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class OperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        OperatorVisitor() {
        }

        public boolean visit(RfHidOperator operator) {
            RfField rhField;
            RfField lhField;
            int operatorType = operator.getOperatorType();
            if (!OPERATOR_TYPE_TOKENS.contains(operatorType)) {
                return true;
            }
            if (operator.isAssignment()) {
                return true;
            }
            if (Check_R_1321.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1321.this.notifyCheckAlive();
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() > 1) {
                return true;
            }
            IHidObject lhValueHid = operator.getLHValue();
            IHidObject rhValueHid = (IHidObject)rhValues.get(0);
            StringBuilder sb = new StringBuilder();
            boolean flagLeft = false;
            if (lhValueHid instanceof RfHid && ((RfHid)lhValueHid).getElement() instanceof RfField && (lhField = (RfField)((RfHid)lhValueHid).getElement()).isEnumElement()) {
                sb.append("'" + lhField.getName() + "'");
                flagLeft = true;
            }
            boolean flagRight = false;
            if (rhValueHid instanceof RfHid && ((RfHid)rhValueHid).getElement() instanceof RfField && (rhField = (RfField)((RfHid)rhValueHid).getElement()).isEnumElement()) {
                if (flagLeft) {
                    sb.append(",");
                }
                sb.append("'" + rhField.getName() + "'");
                flagRight = true;
            }
            if (!flagRight && !flagLeft) {
                return true;
            }
            Check_R_1321.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Enum element" + (flagLeft && flagRight ? "s " : " ") + sb.toString() + " used in comparison: " + operator + "!");
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

