/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractPipelineDriverCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.10")
@CheckID(value="R.1322")
@CheckName(value="R.1322")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.SEQUENCE_ITEM, RuleLabel.DRIVER, RuleLabel.VERIFICATION, RuleLabel.EVENT})
@CheckTitle(value="Event tracking mechanism should be implemented in the sequence item and triggered by the driver")
@CheckDescription(value="A pipeline driver is a driver that calls the get_next_item and item_done method in a single sub-task and not in the run_phase.\nIn case of a pipeline driver, multiple items are in the pipeline for execution and they may get done in out of order. So to track the responses of the transaction which are done, a tracking mechanism is needed in the sequence item.\nThis rule will fail either if the tracking mechanism is missing from the sequence item or if the driver doesn't call the the transaction trigger.\n\nExample:\nclass transaction extends uvm_sequence_item;\n\tuvm_event evt;\n\n\ttask trigger_event();\n\t\tevt.trigger();     // FAIL IF MISSING\n endtask\nendclass\n\nclass my_driver extends uvm_driver#(transaction);\n\n\tvirtual task run_phase(uvm_phase phase);\n\t\tsuper.run_phase(phase);\n\t\titem_task();\n\tendtask : run_phase\n\n\tvirtual task item_task();\n\t\tseq_item_port.get_next_item(req);\n\t\tseq_item_port.item_done(req);\n\tendtask\n\n\tvirtual task trigger();\n\t\treq.trigger_event();  // FAIL IF MISSSING\n\tendtask\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1322
extends AbstractPipelineDriverCheck {
    private static final String TRIGGER = "trigger";

    public Check_R_1322(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkDriver(RfClass driver) {
        PipelineDriverVisitor visitor = new PipelineDriverVisitor();
        driver.visitHidObject(null, visitor);
        if (!visitor.isPipeline()) {
            return;
        }
        RfClass parent = driver.getParent();
        while (parent != null) {
            RfClass localParent = parent;
            if (localParent instanceof RfSpecializedClass) {
                localParent = ((RfSpecializedClass)localParent).getGenericClass();
            }
            if (this.fOVMProject.fOvmDriver.equals(localParent)) break;
            parent = parent.getParent();
        }
        RfClass driverParent = parent;
        if (!(driverParent instanceof RfSpecializedClass)) {
            return;
        }
        IELParamValue transactionValue = ((RfSpecializedClass)driverParent).getElabConstantValue("REQ");
        if (transactionValue == null) {
            return;
        }
        IRfNamedElement transactionElement = transactionValue.getNamedElement();
        if (!(transactionElement instanceof RfClass)) {
            return;
        }
        RfClass transactionClass = (RfClass)transactionElement;
        TransactionClassVisitor transactionVisitor = new TransactionClassVisitor();
        transactionClass.visitHidObject(null, transactionVisitor);
        Set<RfFunction> triggerMethods = transactionVisitor.getTriggerMethods();
        if (triggerMethods.isEmpty()) {
            this.addHit(driver, "The transaction '" + LintUtils.getNamedElementFullName(transactionClass) + "' of pipeline driver '" + LintUtils.getNamedElementFullName(driver) + "' doesn't have event tracking!");
            return;
        }
        Set<RfFunction> driverMethodCalls = visitor.getCalledMethods();
        triggerMethods.retainAll(driverMethodCalls);
        if (triggerMethods.isEmpty()) {
            this.addHit(driver, "Pipeline driver '" + LintUtils.getNamedElementFullName(driver) + "' doesn't call the event tracking from the '" + LintUtils.getNamedElementFullName(transactionClass) + "' transaction!");
        }
    }

    private class PipelineDriverVisitor
    extends AbstractPipelineDriverCheck.AbstractVisitor {
        private Set<RfFunction> calledMethods = new HashSet<RfFunction>();

        private PipelineDriverVisitor() {
        }

        @Override
        protected void additionalMethodChecks(RfHid hidObject, RfFunction function, RfFunction functionScope) {
            this.calledMethods.add(function);
        }

        public Set<RfFunction> getCalledMethods() {
            return this.calledMethods;
        }
    }

    private class TransactionClassVisitor
    extends RfHidVisitor {
        private Set<RfFunction> triggerMethods = new HashSet<RfFunction>();

        private TransactionClassVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (!Check_R_1322.TRIGGER.equals(function.getName())) {
                return true;
            }
            IRfNamedElement triggerScope = function.getEnclosingScope(new HashSet<Class>(Arrays.asList(RfClass.class, RfSpecializedClass.class)));
            if (!(triggerScope instanceof RfClass)) {
                return true;
            }
            RfClass triggerClass = (RfClass)triggerScope;
            if (!Check_R_1322.this.ovmEvent.equals(triggerClass) && !LintUtils.isSubClassOf(triggerClass, Check_R_1322.this.ovmEvent)) {
                return true;
            }
            IRfNamedElement scope = ((HidHolder)this.holder).getScope();
            if (scope == null) {
                return true;
            }
            RfFunction functionScope = (RfFunction)scope.getEnclosingScope(RfFunction.class);
            if (functionScope == null) {
                return true;
            }
            this.triggerMethods.add(functionScope);
            return true;
        }

        public Set<RfFunction> getTriggerMethods() {
            return this.triggerMethods;
        }
    }
}

