/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.11")
@CheckID(value="R.1323")
@CheckName(value="R.1323")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.PHASE, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequences must not have any phase statements in them")
@CheckDescription(value="Sequences must execute identically regardless of the phase in which they are first started in order to preserve their intent and reusability.\nThis rule bans the use of any uvm_phase methods inside sequence classes.\n\nExample:\nclass sequence_class extends uvm_sequence;\n\n  function foo();\n    uvm_phase phase_object = get_starting_phase();\n    phase_object.jump(uvm_pre_reset_phase::get());     // not allowed\n  endtask\n\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1323
extends OVMComplianceCheck {
    private static final String UVM_PHASE = "uvm_pkg::uvm_phase";
    private static final String UVM_SEQUENCE = "uvm_pkg::uvm_sequence";

    public Check_R_1323(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final RfClass phaseBaseClass = this.fOVMProject.getRfProject().getClass(UVM_PHASE, true);
        if (phaseBaseClass == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_phase' not found!");
            return;
        }
        RfClass sequenceBaseClass = this.fOVMProject.getRfProject().getClass(UVM_SEQUENCE, true);
        if (sequenceBaseClass == null) {
            this.addHit(null, "Class 'uvm_pkg::uvm_sequence' not found!");
            return;
        }
        Set<RfClass> allSequenceClasses = this.fOVMProject.getAllXVMSubClasses(sequenceBaseClass);
        for (final RfClass sequenceClass : allSequenceClasses) {
            sequenceClass.visitHidObject(null, new RfHidVisitor(){

                public boolean visit(RfHid hid) {
                    if (!hid.isMethodCall(false)) {
                        return true;
                    }
                    if (Check_R_1323.this.checkPreWaivers(this.parserPath)) {
                        return true;
                    }
                    Check_R_1323.this.notifyCheckAlive();
                    IRfNamedElement element = hid.getElement();
                    if (!(element instanceof RfFunction)) {
                        return true;
                    }
                    IRfScopeElement enclosingScope = element.getEnclosingScope();
                    if (enclosingScope == null || !(enclosingScope instanceof RfClass) || !enclosingScope.equals(phaseBaseClass)) {
                        return true;
                    }
                    Check_R_1323.this.addHit(this.parserPath, hid, "Method '" + LintUtils.getHidFullName((IHid)hid) + "' should not be used inside sequence class '" + LintUtils.getNamedElementFullName(sequenceClass) + "'!");
                    return true;
                }
            });
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

