/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.11")
@CheckID(value="R.1324")
@CheckName(value="R.1324")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.UVM_SEQUENCE, RuleLabel.REGISTER_MODEL, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Register sequences should only access initialized regmodels")
@CheckDescription(value="A register sequence that has any access to registers in a register model should have a variable named <namePattern> that stores a reference to the corresponding register block.\nA register sequence is a sequence class that calls any function declared in 'xvm_pkg::xvm_reg' or 'xvm_pkg::xvm_reg_block'.\n\nExamples:\n\nmy_regmodel_class regmodel;\nfunction void foo();\n    regmodel = new();\n    reg_model.get_field_by_name(\"type_name\");\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1324
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="regmodel", description="The regmodel field name pattern.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pNamePattern;

    public Check_R_1324(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmSequence == null) {
            return;
        }
        String xvmRegClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_reg");
        RfClass xvmRegClass = this.fOVMProject.getRfProject().getClass(xvmRegClassName, true);
        if (xvmRegClass == null) {
            return;
        }
        String xvmRegBlockClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_reg_block");
        RfClass xvmRegBlockClass = this.fOVMProject.getRfProject().getClass(xvmRegBlockClassName, true);
        if (xvmRegBlockClass == null) {
            return;
        }
        Matcher m = null;
        HashSet<RfField> regmodels = new HashSet<RfField>();
        HashSet<RfClass> regmodelClasses = new HashSet<RfClass>();
        regmodelClasses.add(xvmRegBlockClass);
        regmodelClasses.add(xvmRegClass);
        Set<RfClass> allSequences = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmSequence);
        for (RfClass sequence : allSequences) {
            this.notifyCheckAlive();
            RfFileDef file = sequence.getFile();
            if (file == null || this.checkPreWaivers(file.getParserPath())) continue;
            LocalRfHidVisitor visitor = new LocalRfHidVisitor(xvmRegClass, xvmRegBlockClass);
            sequence.visitHidObject(null, visitor);
            if (!visitor.foundXvmRegCall()) continue;
            List<RfField> fields = sequence.getLocalFields();
            if (fields == null || fields.isEmpty()) {
                this.addHit(sequence, "Missing regmodel field that matches pattern '" + this.pNamePattern.toString() + "' in sequence '" + LintUtils.getNamedElementFullName(sequence) + "'!");
                continue;
            }
            boolean hasRegmodel = false;
            for (RfField field : fields) {
                RfClass fieldClass = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldClass == null) continue;
                m = this.pNamePattern.matcher(field.getName());
                if (!LintUtils.isSubClassOfAny(fieldClass, regmodelClasses) || !m.matches()) continue;
                regmodels.add(field);
                hasRegmodel = true;
            }
            if (hasRegmodel) continue;
            this.addHit(sequence, "Missing regmodel field that matches pattern '" + this.pNamePattern.toString() + "' in sequence '" + LintUtils.getNamedElementFullName(sequence) + "'!");
        }
        AssignmentVisitor assignmentVisitor = new AssignmentVisitor(regmodels, m);
        this.fOVMProject.getRfProject().visitHidObject(null, assignmentVisitor);
        for (RfField regmodel : regmodels) {
            this.addHit(regmodel, "Regmodel field '" + regmodel.getName() + "' is not set!");
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class AssignmentVisitor
    implements IHidVisitor<RfHidOperator> {
        private Set<RfField> regmodels;
        private Matcher m;

        public AssignmentVisitor(Set<RfField> regmodels, Matcher m) {
            this.regmodels = regmodels;
            this.m = m;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (!hidObject.isAssignment()) {
                return true;
            }
            IHidObject lhValue = hidObject.getLHValue();
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            RfHid rfHid = (RfHid)lhValue;
            if (!(rfHid.getElement() instanceof RfField)) {
                return true;
            }
            RfField rfField = (RfField)rfHid.getElement();
            this.m = Check_R_1324.this.pNamePattern.matcher(rfField.getName());
            if (!this.m.matches()) {
                return true;
            }
            this.regmodels.remove(rfField);
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    private class LocalRfHidVisitor
    extends RfHidVisitor {
        private boolean foundCall;
        private RfClass xvmRegClass;
        private RfClass xvmRegBlockClass;

        public LocalRfHidVisitor(RfClass xvmRegClass, RfClass xvmRegBlockClass) {
            this.xvmRegClass = xvmRegClass;
            this.xvmRegBlockClass = xvmRegBlockClass;
        }

        public boolean visit(RfHid hid) {
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)hidNamedElement;
            RfClass enclosingClass = function.getEnclosingScope(RfClass.class);
            if (!(function.getFullName().startsWith(this.xvmRegClass.getFullName()) && enclosingClass != null && enclosingClass.equals(this.xvmRegClass) || function.getFullName().startsWith(this.xvmRegBlockClass.getFullName()) && enclosingClass != null && enclosingClass.equals(this.xvmRegBlockClass))) {
                return true;
            }
            this.foundCall = true;
            return false;
        }

        public boolean foundXvmRegCall() {
            return this.foundCall;
        }
    }
}

