/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.11")
@CheckID(value="R.1325")
@CheckName(value="R.1325")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.ENUM})
@CheckTitle(value="Do not use NOT operators with enum")
@CheckDescription(value="This rule flags the usage of NOT operators in enum comparisons because, usually, this is a bug which can be hard to catch.\nThis checks both '~' and '!' operators.\n\nExamples:\nx = (!enum_var inside {FOO, BOO, GOO}); // not allowed\nx = !(enum_var inside {FOO, BOO, GOO}); // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1325
extends OVMComplianceCheck {
    private static final Set<Integer> OPERATOR_TYPE_TOKENS = new HashSet<Integer>(Arrays.asList(478, 479));

    public Check_R_1325(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new OperatorVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    class OperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        OperatorVisitor() {
        }

        public boolean visit(RfHidOperator operator) {
            int operatorType = operator.getOperatorType();
            if (!OPERATOR_TYPE_TOKENS.contains(operatorType)) {
                return true;
            }
            if (operator.isAssignment()) {
                return true;
            }
            if (Check_R_1325.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1325.this.notifyCheckAlive();
            ListContainer rhValues = operator.getRHValues();
            if (rhValues != null) {
                return true;
            }
            IHidObject lhValueHid = operator.getLHValue();
            if (!(lhValueHid instanceof RfHid)) {
                return true;
            }
            IRfNamedElement element = ((RfHid)lhValueHid).getElement();
            if (!(element instanceof RfField)) {
                return true;
            }
            RfField lhField = (RfField)element;
            LintUtils.FullTypeData associatedFinalDataType = LintUtils.getAssociatedFinalDataType(lhField);
            if (associatedFinalDataType == null || !(associatedFinalDataType.getAssocType() instanceof RfStruct)) {
                return true;
            }
            if (((RfStruct)associatedFinalDataType.getAssocType()).isEnum()) {
                Check_R_1325.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "The '" + operator.getOperatorText() + "' operator should not be used on enum variable '" + LintUtils.getNamedElementFullName(lhField) + "'!");
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

