/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.12")
@CheckID(value="R.1326")
@CheckName(value="R.1326")
@CheckLabel(labels={RuleLabel.SEQUENCE_ITEM, RuleLabel.TLM_PORT, RuleLabel.VERIFICATION, RuleLabel.EXTEND})
@CheckTitle(value="Extend the generic payload to create variant of GP sequencer item")
@CheckDescription(value="If a TLM2 port (uvm_tlm_b_transport_port, uvm_tlm_nb_transport_bw_port, uvm_tlm_nb_transport_fw_port, uvm_tlm_b_transport_export, uvm_tlm_nb_transport_bw_export, uvm_tlm_nb_transport_fw_export, uvm_tlm_b_transport_imp, uvm_tlm_nb_transport_bw_imp, uvm_tlm_nb_transport_fw_imp) is used, then there must be at least one class that extends the uvm_tlm_generic_payload class because the UVM factory can override the sequence item at run-time to generate a special type of generic payload.\n\nExamples:\n\nclass payload extends uvm_tlm_generic_payload;\nendclass\n\nfunction foo();\n  tlm2_port.connect(port); // allowed\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1326
extends OVMComplianceCheck {
    private static final String UVM_TLM_GENERIC_PAYLOAD = "uvm_pkg::uvm_tlm_generic_payload";
    private static final String UVM_TLM_B_TRANSPORT_PORT = "uvm_pkg::uvm_tlm_b_transport_port";
    private static final String UVM_TLM_NB_TRANSPORT_BW_PORT = "uvm_pkg::uvm_tlm_nb_transport_bw_port";
    private static final String UVM_TLM_NB_TRANSPORT_FW_PORT = "uvm_pkg::uvm_tlm_nb_transport_fw_port";
    private static final String UVM_TLM_B_TRANSPORT_EXPORT = "uvm_pkg::uvm_tlm_b_transport_export";
    private static final String UVM_TLM_NB_TRANSPORT_BW_EXPORT = "uvm_pkg::uvm_tlm_nb_transport_bw_export";
    private static final String UVM_TLM_NB_TRANSPORT_FW_EXPORT = "uvm_pkg::uvm_tlm_nb_transport_fw_export";
    private static final String UVM_TLM_B_TRANSPORT_IMP = "uvm_pkg::uvm_tlm_b_transport_imp";
    private static final String UVM_TLM_NB_TRANSPORT_BW_IMP = "uvm_pkg::uvm_tlm_nb_transport_bw_imp";
    private static final String UVM_TLM_NB_TRANSPORT_FW_IMP = "uvm_pkg::uvm_tlm_nb_transport_fw_imp";

    public Check_R_1326(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass uvmPayloadClass = this.fOVMProject.getRfProject().getClass(UVM_TLM_GENERIC_PAYLOAD, true);
        if (uvmPayloadClass == null) {
            return;
        }
        RfClass uvmTLM2PortClass1 = this.fOVMProject.getRfProject().getClass(UVM_TLM_B_TRANSPORT_PORT, true);
        if (uvmTLM2PortClass1 == null) {
            return;
        }
        RfClass uvmTLM2PortClass2 = this.fOVMProject.getRfProject().getClass(UVM_TLM_NB_TRANSPORT_BW_PORT, true);
        if (uvmTLM2PortClass2 == null) {
            return;
        }
        RfClass uvmTLM2PortClass3 = this.fOVMProject.getRfProject().getClass(UVM_TLM_NB_TRANSPORT_FW_PORT, true);
        if (uvmTLM2PortClass3 == null) {
            return;
        }
        RfClass uvmTLM2ExportClass1 = this.fOVMProject.getRfProject().getClass(UVM_TLM_B_TRANSPORT_EXPORT, true);
        if (uvmTLM2ExportClass1 == null) {
            return;
        }
        RfClass uvmTLM2ExportClass2 = this.fOVMProject.getRfProject().getClass(UVM_TLM_NB_TRANSPORT_BW_EXPORT, true);
        if (uvmTLM2ExportClass2 == null) {
            return;
        }
        RfClass uvmTLM2ExportClass3 = this.fOVMProject.getRfProject().getClass(UVM_TLM_NB_TRANSPORT_FW_EXPORT, true);
        if (uvmTLM2ExportClass3 == null) {
            return;
        }
        RfClass uvmTLM2ImpClass1 = this.fOVMProject.getRfProject().getClass(UVM_TLM_B_TRANSPORT_IMP, true);
        if (uvmTLM2ImpClass1 == null) {
            return;
        }
        RfClass uvmTLM2ImpClass2 = this.fOVMProject.getRfProject().getClass(UVM_TLM_NB_TRANSPORT_BW_IMP, true);
        if (uvmTLM2ImpClass2 == null) {
            return;
        }
        RfClass uvmTLM2ImpClass3 = this.fOVMProject.getRfProject().getClass(UVM_TLM_NB_TRANSPORT_FW_IMP, true);
        if (uvmTLM2ImpClass3 == null) {
            return;
        }
        final HashSet<RfClass> uvmTLM2BaseClasses = new HashSet<RfClass>(Arrays.asList(uvmTLM2PortClass1, uvmTLM2PortClass2, uvmTLM2PortClass3, uvmTLM2ExportClass1, uvmTLM2ExportClass2, uvmTLM2ExportClass3, uvmTLM2ImpClass1, uvmTLM2ImpClass2, uvmTLM2ImpClass3));
        Set<RfClass> allPayloadChildren = uvmPayloadClass.getChildren();
        if (allPayloadChildren != null && !allPayloadChildren.isEmpty()) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new RfHidVisitor(){
            boolean foundHit;

            public boolean visit(RfHid hidObject) {
                if (this.foundHit) {
                    return false;
                }
                IRfNamedElement element = hidObject.getElement();
                if (element == null || !(element instanceof RfField)) {
                    return true;
                }
                if (Check_R_1326.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1326.this.notifyCheckAlive();
                IRfNamedElement assocDataType = LintUtils.getAssociatedFinalDataType((RfField)element).getAssocType();
                if (!(assocDataType instanceof RfClass)) {
                    return true;
                }
                RfClass parent = (RfClass)assocDataType;
                while (parent.getParent() != null) {
                    if (!LintUtils.isSubClassOfAny(parent = parent.getParent(), uvmTLM2BaseClasses)) continue;
                    Check_R_1326.this.addHit(this.parserPath, hidObject, "The TLM2 port '" + LintUtils.getHidFullName((IHid)hidObject) + "' was used without any class extending the 'uvm_tlm_generic_payload' class!");
                    this.foundHit = true;
                    return false;
                }
                return true;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

