/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractOperatorParenthesesParity;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.18")
@CheckID(value="R.1327")
@CheckName(value="R.1327")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.CONDITIONAL, RuleLabel.CONSTRAINT, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not use operators as predicates of conditional operators in constraints")
@CheckDescription(value="Do not use operators as predicates of conditional operators in constraints because that may lead to unexpected or unkown results.\nIn case of usage of operators as conditional operator predicates, they must be enclosed in parentheses for clarity.\n\nExamples:\n\nconstraint c1 { a == (b ? 36 : 32);};  // allowed\nconstraint c2 { a == b ? 36 : 32;};  // not allowed\nconstraint c3 {(a == b) ? 36 : 32;};  // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1327
extends AbstractOperatorParenthesesParity {
    @CheckParameter(defaultValue="false", description="When true, unary operators as predicates of conditional operators will be skipped.", name="skipUnaryOperators", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipUnaryOperators;

    public Check_R_1327(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (!(hidOperator instanceof RfHidOperator)) {
                    return true;
                }
                if (!(this.scope instanceof RfNamedElement)) {
                    return true;
                }
                if (Check_R_1327.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1327.this.notifyCheckAlive();
                if (!this.isInConstraint((RfNamedElement)this.scope)) {
                    return true;
                }
                if (!hidOperator.isConditionalTernary()) {
                    return true;
                }
                IHidObject lhValue = hidOperator.getLHValue();
                if (!(lhValue instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator lhValueOperator = (RfHidOperator)lhValue;
                if (Check_R_1327.this.pSkipUnaryOperators && this.isUnaryOperator(lhValueOperator)) {
                    return true;
                }
                if (!Check_R_1327.this.checkParanthesisParity(lhValueOperator, (RfHidOperator)hidOperator, this.parserPath)) {
                    Check_R_1327.this.addHit(this.parserPath, (HidOccurrence)lhValueOperator.getOccurrence(), "Operator '" + HidUtils.toString((IHidObject)lhValue, (boolean)true, (boolean)true) + "' should not be used as condition of ternary operator inside constraint!");
                }
                return true;
            }

            private boolean isUnaryOperator(RfHidOperator operator) {
                if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
                    return false;
                }
                return operator.isUnaryPlusOrMinus() || operator.isBitwiseNot() || operator.isLogicalNot() || operator.isReduction() || operator.isIncrementOrDecrement();
            }

            private boolean isInConstraint(RfNamedElement scope) {
                while (scope != null) {
                    if (scope instanceof RfConstraint || scope instanceof RfActionBlock && ((RfActionBlock)scope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.WITH)) {
                        return true;
                    }
                    scope = scope.getEnclosingScope();
                }
                return false;
            }
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

