/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.16")
@CheckID(value="R.1328")
@CheckName(value="R.1328")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.SEQUENCER, RuleLabel.REGISTER_MAP, RuleLabel.REGISTER_MODEL, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not set register sequencer for the default register map of a non-top register block regmodel")
@CheckDescription(value="The register sequencer for the default register map should be set up only if the regmodel is the top register block.\nThis check flags calling 'xvm_pkg::xvm_reg_map.set_sequencer' without guarding this call with a conditional expression.\nThe conditional expression must check if the regmodel is the top register block.\n\nExample:\n\nfunction void connect_phase(uvm_phase phase);\n    if (regmodel.get_parent() == null) begin\n        regmodel.default_map.set_sequencer(sequencer, adapter); // allowed\n    end\n\n    regmodel.default_map.set_sequencer(sequencer, adapter); // not allowed\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1328
extends OVMComplianceCheck {
    private static final String UVM_REG_BLOCK = "uvm_pkg::uvm_reg_block";
    private static final String UVM_REG_MAP = "uvm_pkg::uvm_reg_map";
    private static final String DEFAULT_MAP = "default_map";
    private static final String SET_SEQUENCER = "set_sequencer";
    private static final String GET_PARENT = "get_parent";

    public Check_R_1328(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass xvmRegBlockClass = this.fOVMProject.getRfProject().getClass(UVM_REG_BLOCK, true);
        if (xvmRegBlockClass == null) {
            return;
        }
        RfClass xvmRegMapClass = this.fOVMProject.getRfProject().getClass(UVM_REG_MAP, true);
        if (xvmRegMapClass == null) {
            return;
        }
        RfField defaultMapField = xvmRegBlockClass.getFieldWithPrefix(DEFAULT_MAP, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (defaultMapField == null) {
            return;
        }
        RfFunction setSequencerFunction = xvmRegMapClass.getFunctionWithPrefix(SET_SEQUENCER, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (setSequencerFunction == null) {
            return;
        }
        RfFunction getParentFunction = xvmRegBlockClass.getFunctionWithPrefix(GET_PARENT, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (getParentFunction == null) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(null, new LocalRfHidVisitor(xvmRegBlockClass, defaultMapField, setSequencerFunction, getParentFunction));
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class LocalRfHidVisitor
    extends RfHidVisitor {
        private RfClass xvmRegBlockClass;
        private RfField defaultMapField;
        private RfFunction setSequencerFunction;
        private RfFunction getParentFunction;
        private IRfNamedElement scope;

        public LocalRfHidVisitor(RfClass xvmRegBlockClass, RfField defaultMapField, RfFunction setSequencerFunction, RfFunction getParentFunction) {
            this.xvmRegBlockClass = xvmRegBlockClass;
            this.defaultMapField = defaultMapField;
            this.setSequencerFunction = setSequencerFunction;
            this.getParentFunction = getParentFunction;
        }

        public boolean visit(RfHid hid) {
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            if (Check_R_1328.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1328.this.notifyCheckAlive();
            RfFunction function = (RfFunction)hidNamedElement;
            if (!function.equals(this.setSequencerFunction)) {
                return true;
            }
            if (hid.getAncestorHid() == null || !(hid.getAncestorHid().getElement() instanceof RfField)) {
                return true;
            }
            if (hid.getParentHid() == null || !(hid.getParentHid().getElement() instanceof RfField)) {
                return true;
            }
            RfField parentHidField = (RfField)hid.getParentHid().getElement();
            if (!parentHidField.equals(this.defaultMapField)) {
                return true;
            }
            RfField ancestorField = (RfField)hid.getAncestorHid().getElement();
            if (ancestorField == null || parentHidField.equals(ancestorField)) {
                return true;
            }
            RfClass ancestorFieldClass = LintUtils.getFieldFinalClassTypeOrNull(ancestorField);
            if (ancestorFieldClass == null || !LintUtils.isSubClassOf(ancestorFieldClass, this.xvmRegBlockClass)) {
                return true;
            }
            IRfNamedElement enclScope = this.scope;
            while (enclScope != null) {
                RfHidOperator operator;
                RfActionBlock block;
                if (enclScope instanceof RfActionBlock && ((RfActionBlock)enclScope).isConditionalWithExpression() && (block = (RfActionBlock)enclScope).getConditionalBlockExpression() instanceof RfHidOperator && (operator = (RfHidOperator)block.getConditionalBlockExpression()).isEquality()) {
                    IHidObject lhValue = operator.getLHValue();
                    ListContainer rhValues = operator.getRHValues();
                    if (rhValues != null && rhValues.size() == 1 && (this.isNull((IHidObject)rhValues.get(0)) && this.isParentCall(lhValue, ancestorField, this.getParentFunction) || this.isNull(lhValue) && this.isParentCall((IHidObject)rhValues.get(0), ancestorField, this.getParentFunction))) {
                        return true;
                    }
                }
                enclScope = enclScope.getEnclosingScope();
            }
            Check_R_1328.this.addHit(this.parserPath, hid.getOccurrence(), "Setting register sequencer for a regmodel that might not be the top register block: '" + LintUtils.getNamedElementFullName(ancestorField) + "'!");
            return true;
        }

        private boolean isNull(IHidObject hidObject) {
            if (!(hidObject instanceof RfHidImplicit)) {
                return false;
            }
            RfHidImplicit hidImplicit = (RfHidImplicit)hidObject;
            return hidImplicit.isLiteralNull();
        }

        private boolean isParentCall(IHidObject lhValue, RfField regmodelField, RfFunction getParentFunction) {
            if (!(lhValue instanceof RfHidAccessArgs)) {
                return false;
            }
            Hid parentHid = ((RfHidAccessArgs)lhValue).getParentHid();
            if (!(parentHid instanceof RfHid) || !(((RfHid)parentHid).getElement() instanceof RfFunction)) {
                return false;
            }
            RfFunction function = (RfFunction)((RfHid)parentHid).getElement();
            if (!function.equals(getParentFunction)) {
                return false;
            }
            if (!(((RfHid)parentHid).getParentHid() instanceof RfHid) || !(((RfHid)((RfHid)parentHid).getParentHid()).getElement() instanceof RfField)) {
                return false;
            }
            RfField field = (RfField)((RfHid)((RfHid)parentHid).getParentHid()).getElement();
            return field.equals(regmodelField);
        }

        @Override
        public void setHolder(IHidHolder holder) {
            if (holder instanceof RfHidHolder) {
                this.scope = ((RfHidHolder)holder).getScope();
            }
        }

        @Override
        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }
    }
}

