/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="24.1.16")
@CheckID(value="R.1329")
@CheckName(value="R.1329")
@CheckLabel(labels={RuleLabel.REGISTER, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="For all registers and memory that are accessed using the backdoor must provide a HDL path")
@CheckDescription(value="All registers that are accessed with API that uses UVM_BACKDOOR must also set a HDL path using 'add_hdl_path'.\nImplementation notes: a backdoor access is considered if the path is specifically set to 'UVM_BACKDOOR'.\nIf a path is not specified, then the register access will not be considered.\nThe only exception to this rule is the 'uvm_reg::predict()' method, which performs a frontdoor access without explicitly specifying a path.\nFor registers that have the backdoor access in the same method scope as the 'add_hdl_path' call, we will also consider their order.\nExample:\n\nreg1.add_hdl_path(\"slices\", \"RTL\");\nreg1.read(status, rdata, UVM_BACKDOOR);  // ALLOWED\n\nreg2.read(status, rdata, UVM_BACKDOOR);  // NOT ALLOWED\n\nCheck supports pre-waiving.")
public class Check_R_1329
extends OVMComplianceCheck {
    private RfClass registerClass;
    private final Set<String> checkedFunctions = new HashSet<String>(Arrays.asList("read", "write", "mirror", "update", "predict"));
    private final Set<String> provideHDLPathMethods = new HashSet<String>(Arrays.asList("add_hdl_path"));

    public Check_R_1329(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.registerClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_reg"), true);
        if (this.registerClass == null) {
            return;
        }
        LocalReadWriteVisitor readWriteVisitor = new LocalReadWriteVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, readWriteVisitor);
        Map<DVTPair<RfField, RfHidAccess>, Set<DVTPair<RfNamedElement, RfHid>>> accessAndEnclosingFunctionForRegister = readWriteVisitor.getAccessAndEnclosingFunctionForRegisterBackdoor();
        Map<DVTPair<RfField, RfHidAccess>, Set<RfNamedElement>> enclosingFunctionsForRegisterHDLPath = readWriteVisitor.getEnclosingFunctionsForRegisterHDLPath();
        Map<RfNamedElement, Map<DVTPair<RfField, RfHidAccess>, RfHid>> registerAccessInFunctionHDLPath = readWriteVisitor.getRegisterAccessInFunctionHDLPath();
        for (Map.Entry<DVTPair<RfField, RfHidAccess>, Set<DVTPair<RfNamedElement, RfHid>>> entry : accessAndEnclosingFunctionForRegister.entrySet()) {
            DVTPair<RfField, RfHidAccess> reg = entry.getKey();
            Set<DVTPair<RfNamedElement, RfHid>> backdoorAccesses = entry.getValue();
            for (DVTPair<RfNamedElement, RfHid> access : backdoorAccesses) {
                RfNamedElement backdoorAccessEnclosingFunction = (RfNamedElement)access.getKey();
                RfHid backdoorAccess = (RfHid)((Object)access.getValue());
                Set<RfNamedElement> hdlSetPathEnclosingFunction = enclosingFunctionsForRegisterHDLPath.get(reg);
                if (hdlSetPathEnclosingFunction == null) {
                    this.addLocalHit(backdoorAccess, backdoorAccessEnclosingFunction, -1);
                    continue;
                }
                if (!hdlSetPathEnclosingFunction.contains(backdoorAccessEnclosingFunction) || backdoorAccess.getLine() >= registerAccessInFunctionHDLPath.get(backdoorAccessEnclosingFunction).get(reg).getLine()) continue;
                this.addLocalHit(backdoorAccess, backdoorAccessEnclosingFunction, registerAccessInFunctionHDLPath.get(backdoorAccessEnclosingFunction).get(reg).getLine());
            }
        }
    }

    private void addLocalHit(RfHid hid, RfNamedElement scope, int lineOfHDLCall) {
        if (lineOfHDLCall >= 0) {
            this.addHit(scope.getFile().getParserPath(), hid.getOccurrence(), "Register '" + HidUtils.toNiceString((IHidObject)hid.getParentHid()) + "' is accessed by backdoor but does not set an HDL path until the call at line " + lineOfHDLCall + "!", null);
        } else {
            this.addHit(scope.getFile().getParserPath(), hid.getOccurrence(), "Register '" + HidUtils.toNiceString((IHidObject)hid.getParentHid()) + "' is accessed by backdoor but does not set an HDL path!", null);
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalReadWriteVisitor
    implements IHidVisitor<RfHid> {
        private RfNamedElement scope;
        private ParserPath parserPath;
        private final Map<DVTPair<RfField, RfHidAccess>, Set<DVTPair<RfNamedElement, RfHid>>> accessAndEnclosingFunctionForRegisterBackdoor = new HashMap<DVTPair<RfField, RfHidAccess>, Set<DVTPair<RfNamedElement, RfHid>>>();
        private final Map<DVTPair<RfField, RfHidAccess>, Set<RfNamedElement>> enclosingFunctionsForRegisterHDLPath = new HashMap<DVTPair<RfField, RfHidAccess>, Set<RfNamedElement>>();
        private final Map<RfNamedElement, Map<DVTPair<RfField, RfHidAccess>, RfHid>> registerAccessInFunctionHDLPath = new HashMap<RfNamedElement, Map<DVTPair<RfField, RfHidAccess>, RfHid>>();

        public boolean visit(RfHid hid) {
            if (!hid.isMethodCall(false)) {
                return true;
            }
            if (this.scope.isPredefined()) {
                return true;
            }
            if (Check_R_1329.this.fOVMProject.isOVMFile(LintUtils.getFileShortName(this.parserPath.path))) {
                return true;
            }
            if (Check_R_1329.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1329.this.notifyCheckAlive();
            if (!Check_R_1329.this.checkedFunctions.contains(hid.getName()) && !Check_R_1329.this.provideHDLPathMethods.contains(hid.getName())) {
                return true;
            }
            HidAccess parrentAccess = hid.getParentAccess();
            if (parrentAccess == null) {
                return true;
            }
            if (!(parrentAccess instanceof RfHidAccess)) {
                return true;
            }
            RfHidAccess regAccess = (RfHidAccess)parrentAccess;
            IRfNamedElement parrentAssociatedType = parrentAccess.getAssociatedType();
            if (!(parrentAccess.getParentHid() instanceof RfHid)) {
                return true;
            }
            RfHid parentHid = (RfHid)parrentAccess.getParentHid();
            if (!(parentHid.getElement() instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)parentHid.getElement();
            if (!(parrentAssociatedType instanceof RfClass)) {
                return true;
            }
            if (!LintUtils.isSubClassOf((RfClass)parrentAssociatedType, Check_R_1329.this.registerClass)) {
                return true;
            }
            RfFunction functionScope = this.scope.getEnclosingScope(RfFunction.class);
            if (functionScope == null) {
                return true;
            }
            DVTPair reg = new DVTPair((Object)field, (Object)regAccess);
            if (Check_R_1329.this.checkedFunctions.contains(hid.getName())) {
                LintUtils.PathType accessType = LintUtils.getAccessType(hid, hid.getName());
                if (accessType == LintUtils.PathType.BACKDOOR) {
                    this.accessAndEnclosingFunctionForRegisterBackdoor.putIfAbsent((DVTPair<RfField, RfHidAccess>)reg, new HashSet());
                    this.accessAndEnclosingFunctionForRegisterBackdoor.get(reg).add((DVTPair<RfNamedElement, RfHid>)new DVTPair((Object)functionScope, (Object)hid));
                }
            } else {
                this.enclosingFunctionsForRegisterHDLPath.putIfAbsent((DVTPair<RfField, RfHidAccess>)reg, new HashSet());
                this.enclosingFunctionsForRegisterHDLPath.get(reg).add(functionScope);
                this.registerAccessInFunctionHDLPath.putIfAbsent(functionScope, new HashMap());
                if (this.registerAccessInFunctionHDLPath.get(functionScope).containsKey(reg) && hid.getOffset() > this.registerAccessInFunctionHDLPath.get(functionScope).get(reg).getOffset()) {
                    return true;
                }
                this.registerAccessInFunctionHDLPath.get(functionScope).put((DVTPair<RfField, RfHidAccess>)reg, hid);
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Map<DVTPair<RfField, RfHidAccess>, Set<DVTPair<RfNamedElement, RfHid>>> getAccessAndEnclosingFunctionForRegisterBackdoor() {
            return this.accessAndEnclosingFunctionForRegisterBackdoor;
        }

        public Map<DVTPair<RfField, RfHidAccess>, Set<RfNamedElement>> getEnclosingFunctionsForRegisterHDLPath() {
            return this.enclosingFunctionsForRegisterHDLPath;
        }

        public Map<RfNamedElement, Map<DVTPair<RfField, RfHidAccess>, RfHid>> getRegisterAccessInFunctionHDLPath() {
            return this.registerAccessInFunctionHDLPath;
        }
    }
}

