/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.16")
@CheckID(value="R.1330")
@CheckName(value="R.1330")
@CheckLabel(labels={RuleLabel.SEQUENCE_ITEM, RuleLabel.TRANSLATOR, RuleLabel.VERIFICATION})
@CheckTitle(value="Every Bus UVC should provide translators between GP and specific bus function")
@CheckDescription(value="If there is GP usage, then there must be a translator between the GP variable and the sequence item.\nA translator is a class that extends from uvm_component and has a function with input GP and output sequence item.\n\nExample:\n\nclass translator extends uvm_component;\n    function translate(my_payload payload, my_sequence_item sequence_item);\n        // implementation\n    endfunction\nendclass\n\nfunction foo();\n    payload = new(); // allowed\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1330
extends OVMComplianceCheck {
    private static final String UVM_TLM_GENERIC_PAYLOAD = "uvm_pkg::uvm_tlm_generic_payload";

    public Check_R_1330(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass uvmPayloadClass = this.fOVMProject.getRfProject().getClass(UVM_TLM_GENERIC_PAYLOAD, true);
        if (uvmPayloadClass == null) {
            return;
        }
        if (this.fOVMProject.fOvmComponent == null || this.fOVMProject.fOvmSequenceItem == null) {
            return;
        }
        LocalRfHidVisitor visitor = new LocalRfHidVisitor(uvmPayloadClass);
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
        HitInfo hit = visitor.getHit();
        if (hit == null) {
            return;
        }
        Set<RfClass> allComponents = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmComponent);
        if (allComponents == null || allComponents.isEmpty()) {
            this.addHit(hit.getField(), "There is no translator between the GP variable and the sequence item!");
            return;
        }
        for (RfClass component : allComponents) {
            List<RfFunction> localFunctions = component.getLocalFunctions();
            if (localFunctions == null || localFunctions.isEmpty()) continue;
            for (RfFunction function : localFunctions) {
                List<IRfFieldElement> arguments;
                if (function.isPredefined() || (arguments = function.getArguments()) == null || arguments.isEmpty()) continue;
                boolean hasPayload = false;
                boolean hasSequenceItem = false;
                IRfNamedElement functionType = function.getResolvedType(true);
                if (functionType instanceof RfClass && LintUtils.isSubClassOf((RfClass)functionType, this.fOVMProject.fOvmSequenceItem)) {
                    hasSequenceItem = true;
                }
                for (IRfFieldElement argument : arguments) {
                    IRfNamedElement fieldType;
                    if (!(argument instanceof RfAssociatedType) || !((fieldType = LintUtils.getAssociatedFinalDataType((RfAssociatedType)argument).getAssocType()) instanceof RfClass)) continue;
                    RfClass fieldClass = (RfClass)fieldType;
                    if (!hasPayload && argument.isInput() && LintUtils.isSubClassOf(fieldClass, uvmPayloadClass)) {
                        hasPayload = true;
                    }
                    if (!hasSequenceItem && argument.isOutput() && LintUtils.isSubClassOf(fieldClass, this.fOVMProject.fOvmSequenceItem)) {
                        hasSequenceItem = true;
                    }
                    if (!hasPayload || !hasSequenceItem) continue;
                    return;
                }
            }
        }
        this.addHit(hit.getField(), "There is no translator between the GP variable and the sequence item!");
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    static class HitInfo {
        private RfField field;
        private ParserPath parserPath;

        public HitInfo(ParserPath parserPath, RfField field) {
            this.parserPath = parserPath;
            this.field = field;
        }

        public RfField getField() {
            return this.field;
        }

        public ParserPath getParserPath() {
            return this.parserPath;
        }
    }

    class LocalRfHidVisitor
    extends RfHidVisitor {
        private RfClass uvmPayloadClass;
        private HitInfo hitInfo;

        public LocalRfHidVisitor(RfClass uvmPayloadClass) {
            this.uvmPayloadClass = uvmPayloadClass;
        }

        public boolean visit(RfHid hidObject) {
            if (this.getHit() != null) {
                return false;
            }
            IRfNamedElement element = hidObject.getElement();
            if (element == null || !(element instanceof RfField)) {
                return true;
            }
            if (Check_R_1330.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1330.this.notifyCheckAlive();
            IRfNamedElement assocDataType = LintUtils.getAssociatedFinalDataType((RfField)element).getAssocType();
            if (!(assocDataType instanceof RfClass)) {
                return true;
            }
            RfClass parent = (RfClass)assocDataType;
            while (parent.getParent() != null) {
                if (!LintUtils.isSubClassOf(parent = parent.getParent(), this.uvmPayloadClass)) continue;
                this.hitInfo = new HitInfo(this.parserPath, (RfField)element);
                return false;
            }
            return true;
        }

        public HitInfo getHit() {
            return this.hitInfo;
        }
    }
}

