/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.16")
@CheckID(value="R.1331")
@CheckName(value="R.1331")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.VIRTUAL_INTERFACE, RuleLabel.AGENT, RuleLabel.CONFIG_DB, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not collect the same virtual interface in different variables")
@CheckDescription(value="There should be a single connection between the agent and the interface.\n\nImplementation Notes:\nThis rule checks the uvm_config_db::get calls in test classes. Get calls for the same instance are flagged.\n\nExample:\n\nuvm_config_db::get(this, \"\", \"vif\", outputvar1);\nuvm_config_db::get(this, \"\", \"vif\", outputvar2);  //not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1331
extends OVMComplianceCheck {
    public Check_R_1331(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String testClassName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_test");
        RfClass testClass = this.fOVMProject.getRfProject().getClass(testClassName, true);
        Set<RfClass> testsClasses = this.fOVMProject.getAllXVMSubClasses(testClass);
        for (RfClass clazz : testsClasses) {
            List<CustomMethodCall> getCalls = this.collectGetCalls(clazz);
            HashMap<DVTPair, CustomMethodCall> instancesMap = new HashMap<DVTPair, CustomMethodCall>();
            for (CustomMethodCall call : getCalls) {
                DVTPair instName = new DVTPair((Object)call.fieldName, (Object)call.instanceName);
                if (instancesMap.containsKey(instName) && !((CustomMethodCall)instancesMap.get((Object)instName)).value.equals(call.value)) {
                    CustomMethodCall sameCallValue = (CustomMethodCall)instancesMap.get(instName);
                    this.addHit(call.parserPath, call.methodCall.getOccurrence().getLine(), "Same instance " + call.instanceName + " and field name " + call.fieldName + " were used for value '" + sameCallValue.value.getName() + "'!", null);
                    continue;
                }
                instancesMap.put(instName, call);
            }
        }
    }

    private List<CustomMethodCall> collectGetCalls(RfClass clazz) {
        final LinkedList<CustomMethodCall> getCalls = new LinkedList<CustomMethodCall>();
        clazz.visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                if (hid == null) {
                    return true;
                }
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                IRfNamedElement hidNamedElement = hid.getElement();
                if (!(hidNamedElement instanceof RfFunction)) {
                    return true;
                }
                if (Check_R_1331.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1331.this.notifyCheckAlive();
                String shortFileName = LintUtils.getFileShortName(this.parserPath.toString());
                if (Check_R_1331.this.fOVMProject.isOVMFile(shortFileName)) {
                    return true;
                }
                if (this.isCalling(hid, "uvm_pkg::uvm_config_db")) {
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                    if (methodCalls.isEmpty()) {
                        return true;
                    }
                    for (MethodCall methodCall : methodCalls) {
                        CustomMethodCall customeMethodCall;
                        String methodName = methodCall.getMethodHid().getName();
                        if (!methodName.equals("get") || (customeMethodCall = this.createCustomMethodCall(methodCall)) == null || !methodName.equals("get")) continue;
                        getCalls.add(customeMethodCall);
                    }
                }
                return true;
            }

            private CustomMethodCall createCustomMethodCall(MethodCall methodCall) {
                if (methodCall.argumentValuesMapRaw == null) {
                    return null;
                }
                RfHidImplicit fieldName = null;
                RfHidImplicit instanceName = null;
                RfField value = null;
                for (IRfNamedElement key : methodCall.argumentValuesMapRaw.keySet()) {
                    IHidObject val = (IHidObject)methodCall.argumentValuesMapRaw.get(key);
                    if (key.getName().equals("field_name") && val instanceof RfHidImplicit) {
                        fieldName = (RfHidImplicit)val;
                        continue;
                    }
                    if (key.getName().equals("inst_name") && val instanceof RfHidImplicit && !((RfHidImplicit)val).getName().contains("*")) {
                        instanceName = (RfHidImplicit)val;
                        continue;
                    }
                    if (!key.getName().equals("value") || !(val instanceof RfHid)) continue;
                    if (((RfHid)val).getElement() instanceof RfField) {
                        value = (RfField)((RfHid)val).getElement();
                    }
                    if (LintUtils.isVirtualInterface(value)) continue;
                    return null;
                }
                if (fieldName == null || instanceName == null || value == null) {
                    return null;
                }
                return new CustomMethodCall(this.parserPath, methodCall, value, instanceName, fieldName);
            }

            private boolean isCalling(RfHid rfHid, String calledFunction) {
                HidAccess parentAccess = rfHid.getParentAccess();
                if (parentAccess == null) {
                    return false;
                }
                IRfNamedElement associatedType = parentAccess.getAssociatedType();
                if (associatedType == null || !(associatedType instanceof RfClass)) {
                    return false;
                }
                String name = ((RfClass)associatedType).getFullName();
                return name != null && name.equals(calledFunction);
            }
        });
        return getCalls;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static class CustomMethodCall {
        public RfHidImplicit fieldName;
        public RfHidImplicit instanceName;
        public RfField value;
        public MethodCall methodCall;
        public ParserPath parserPath;

        public CustomMethodCall(ParserPath parserPath, MethodCall methodCall, RfField value, RfHidImplicit instanceName, RfHidImplicit fieldName) {
            this.parserPath = parserPath;
            this.methodCall = methodCall;
            this.value = value;
            this.instanceName = instanceName;
            this.fieldName = fieldName;
        }
    }
}

