/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.18")
@CheckID(value="R.1332")
@CheckName(value="R.1332")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.DRIVER, RuleLabel.ASSIGNMENT, RuleLabel.MODULE, RuleLabel.INTERFACE, RuleLabel.VERIFICATION})
@CheckTitle(value="Signal driving should only be done in drivers")
@CheckDescription(value="This check flags assignments to module and interface signals done in XVM classes that are not drivers.\nIt also flags such assignments done in drivers if the right hand side of the assignment contains a non-driver field or it is not a sequence item.\n\nExamples:\n\nclass my_monitor extends xvm_monitor;\n\tmonitor_field = 3;\n\n\t// monitor implementation\n\n\ttask monitor_task();\n\t\tvif.a <= 3;\t\t\t\t\t\t\t// not allowed\n\tendtask\nendclass\n\nclass my_driver extends xvm_driver;\n\tmy_monitor mon;\n\n\t// driver implementation\n\n\ttask driver_task();\n\t\tvif.a <= 3;\t\t\t\t\t\t\t// allowed\n\t\tvif.a <= mon.monitor_field;\t\t\t// not allowed\n\tendtask\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1332
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of full names of classes for which the extending classes can drive signals.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipBaseClassesValue;
    private HashSet<RfClass> skipBaseRfClasses;
    private static final String ERROR_MESSAGE_NON_DRIVER = "Signal ''{0}'' is driven in class ''{1}'', which is not a driver!";
    private static final String ERROR_MESSAGE_DRIVER = "Signal ''{0}'' is indirectly driven in class ''{1}'' by the ''{2}'' field, which is not a driver field!";

    public Check_R_1332(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    public void setIgnoreRfClasses(HashSet<String> ignoreClasses) {
        this.skipBaseRfClasses = new HashSet();
        for (String clazz : ignoreClasses) {
            RfClass rfClazz = this.fOVMProject.getRfProject().getClass(clazz, true);
            if (rfClazz == null) continue;
            this.skipBaseRfClasses.add(rfClazz);
        }
    }

    @Override
    public void performCheckImpl() {
        this.setIgnoreRfClasses(this.pSkipBaseClassesValue);
        RfClass xvmVoid = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_void"), true);
        if (xvmVoid == null) {
            return;
        }
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            RfFileDef file;
            if (!(clazz instanceof RfClass) || (file = clazz.getFile()) == null || this.checkPreWaivers(file.getParserPath())) continue;
            this.notifyCheckAlive();
            if (!LintUtils.isSubClassOf((RfClass)clazz, xvmVoid) || !this.skipBaseRfClasses.isEmpty() && LintUtils.isSubClassOfAny((RfClass)clazz, this.skipBaseRfClasses)) continue;
            LocalHidOperatorVisitor hidOperatorVisitor = new LocalHidOperatorVisitor(LintUtils.isSubClassOf((RfClass)clazz, this.fOVMProject.fOvmDriver), LintUtils.getNamedElementFullName(clazz));
            clazz.visitHidObject(null, (IHidVisitor<?>)hidOperatorVisitor);
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    static /* synthetic */ OVMProject access$1(Check_R_1332 check_R_1332) {
        return check_R_1332.fOVMProject;
    }

    private final class LocalHidOperatorVisitor
    extends HidOperatorVisitor {
        private boolean isDriver;
        private String className;

        private LocalHidOperatorVisitor(boolean isDriver, String className) {
            super(null);
            this.isDriver = isDriver;
            this.className = className;
        }

        public boolean visit(HidOperator operator) {
            RfClass classScope = ((RfNamedElement)this.scope).getEnclosingScope(RfClass.class);
            if (classScope == null) {
                return true;
            }
            if (operator.isAssignment()) {
                IHidObject lhValue = operator.getLHValue();
                while (lhValue instanceof RfHidAccess) {
                    lhValue = ((RfHidAccess)lhValue).getParentHid();
                }
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement iLhElement = ((RfHid)lhValue).getElement();
                if (!(iLhElement instanceof RfField)) {
                    return true;
                }
                RfField lhField = (RfField)iLhElement;
                RfNamedElement lhEnclosingScope = lhField.getEnclosingScope();
                if (!(lhEnclosingScope instanceof RfInterface) && !(lhEnclosingScope instanceof RfModule)) {
                    return true;
                }
                if (!this.isDriver) {
                    Check_R_1332.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), MessageFormat.format(Check_R_1332.ERROR_MESSAGE_NON_DRIVER, LintUtils.getNamedElementFullName(lhField), this.className));
                    return true;
                }
                IHidObject rhValue = operator.getFirstRHValue();
                if (rhValue == null) {
                    return true;
                }
                if (rhValue instanceof RfHidOperator) {
                    HidOperator rhHidOperator = (HidOperator)rhValue;
                    HashSet hids = new HashSet();
                    Predicate<IHidObject> result = element -> {
                        if (element instanceof RfHidOperator && ((RfHidOperator)element).isConditionalTernary()) {
                            ListContainer rhTernaryValues = ((RfHidOperator)element).getRHValues();
                            for (IHidObject rhTernaryValue : rhTernaryValues) {
                                IHid rhHid = HidUtils.getHidFrom((IHidObject)rhTernaryValue);
                                if (rhHid != null) {
                                    hids.add(rhHid);
                                }
                                Set operatorHids = new HashSet();
                                if (rhTernaryValue instanceof RfHidOperator) {
                                    operatorHids = HidUtils.flattenToHids((IHidObject)rhTernaryValue, EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
                                }
                                if (operatorHids == null) continue;
                                hids.addAll(operatorHids);
                            }
                            return false;
                        }
                        IHid hid = HidUtils.getHidFrom((IHidObject)element);
                        if (hid != null) {
                            hids.add(hid);
                        }
                        return true;
                    };
                    if (rhHidOperator.isConditionalTernary()) {
                        ListContainer rhValues = rhHidOperator.getRHValues();
                        if (rhValues == null) {
                            return true;
                        }
                        for (IHidObject rhVal : rhValues) {
                            HidUtils.flattenToObjects(result, (IHidObject)rhVal, EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
                        }
                    } else {
                        HidUtils.flattenToObjects(result, (IHidObject)rhValue, EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
                    }
                    if (hids == null || hids.isEmpty()) {
                        return true;
                    }
                    for (IHid rhHid : hids) {
                        if (!this.checkHid((IHidObject)rhHid, lhField, operator)) continue;
                        return true;
                    }
                } else {
                    this.checkHid(rhValue, lhField, operator);
                }
                return true;
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        private boolean checkHid(IHidObject hidObject, RfField lhField, HidOperator operator) {
            block12: {
                rfHid = null;
                if (hidObject instanceof RfHidAccess) {
                    rfHid = ((RfHidAccess)hidObject).getParentHid();
                } else if (hidObject instanceof RfHid) {
                    rfHid = (Hid)hidObject;
                } else {
                    return false;
                }
                if (!(rfHid instanceof RfHid)) {
                    return false;
                }
                if (rfHid.getElement() instanceof RfThisImplicitVariable) {
                    return false;
                }
                if (rfHid.getParentAccess() == null) break block12;
                hidParentAccess = rfHid.getParentAccess();
                if (hidParentAccess == null) {
                    return false;
                }
                rfHid = hidParentAccess.getParentHid();
                if (rfHid != null) ** GOTO lbl22
                return false;
                while (rfHid.getParentAccess().getParentHid() == null || !(rfHid.getParentAccess().getParentHid().getElement() instanceof RfThisImplicitVariable)) {
                    rfHid = rfHid.getParentAccess().getParentHid();
lbl22:
                    // 2 sources

                    if (rfHid != null && rfHid.getParentAccess() != null) continue;
                }
                if (rfHid == null) {
                    return false;
                }
            }
            if (!((element = rfHid.getElement()) instanceof RfField)) {
                return false;
            }
            elementField = (RfField)element;
            classType = LintUtils.getFieldFinalClassTypeOrNull(elementField);
            if (classType == null && ((elementFieldScopeClass = elementField.getEnclosingScope(RfClass.class)) == null || LintUtils.isSubClassOf(elementFieldScopeClass, Check_R_1332.access$1((Check_R_1332)Check_R_1332.this).fOvmDriver))) {
                return false;
            }
            if (LintUtils.isSubClassOf(classType, Check_R_1332.access$1((Check_R_1332)Check_R_1332.this).fOvmSequenceItem)) {
                return false;
            }
            Check_R_1332.access$0(Check_R_1332.this, this.parserPath, (HidOccurrence)operator.getOccurrence(), MessageFormat.format("Signal ''{0}'' is indirectly driven in class ''{1}'' by the ''{2}'' field, which is not a driver field!", new Object[]{LintUtils.getNamedElementFullName(lhField), this.className, LintUtils.getNamedElementFullName(classType)}));
            return true;
        }
    }
}

