/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.18")
@CheckID(value="R.1333")
@CheckName(value="R.1333")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERGROUP, RuleLabel.COVERPOINT})
@CheckTitle(value="Do not define bins outside of the possible range of the covered variable")
@CheckDescription(value="This check flags bins defined with values not within the possible range of the covered variable.\nBins with values outside of the possible range of the covered variable will be modified according to that range.\n\nExamples:\n\nreg [2:0] v;\ncovergroup cg;\n    cp : coverpoint v {\n        bins b1 = {[0 : 15]}; // not allowed\n        bins b2 = {[0 : 4]};  // allowed\n    }\nendgroup\n\nCheck supports pre-waiving.")
public class Check_R_1333
extends OVMComplianceCheck {
    public Check_R_1333(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfCovergroup[] allCovergroups;
        RfProject rfProject = this.fOVMProject.getRfProject();
        ELManager manager = rfProject.getELManager();
        ELParamValuesHidEvaluator emptyEvaluator = ELParamValues.EMPTY.getHidEvaluator(manager);
        RfCovergroup[] rfCovergroupArray = allCovergroups = this.fOVMProject.getRfProject().getAllCovergroups();
        int n = allCovergroups.length;
        int n2 = 0;
        while (n2 < n) {
            List<RfCoverpoint> coverpoints;
            RfCovergroup covergroup = rfCovergroupArray[n2];
            this.notifyCheckAlive();
            RfDefElement defElement = covergroup.getDeclaration();
            if (defElement != null && !this.checkPreWaivers(defElement.getParserPath()) && (coverpoints = covergroup.getLocalMembers(RfCoverpoint.class)) != null && !coverpoints.isEmpty()) {
                for (RfCoverpoint coverpoint : coverpoints) {
                    RfHid hid;
                    IHidObject coverpointExpression = coverpoint.getExpression();
                    IHidObject expression = coverpointExpression;
                    if (expression instanceof RfHidAccess) {
                        expression = ((RfHidAccess)expression).getParentHid();
                    }
                    if (!(expression instanceof RfHid) || !((hid = (RfHid)expression).getElement() instanceof RfField)) continue;
                    RfField field = (RfField)hid.getElement();
                    IHidEvaluationGuardian guardianForSize = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)field, null, (boolean)true, (ELManager)manager);
                    guardianForSize.updateElements((IRfNamedElement)field, (IRfNamedElement)coverpoint);
                    IHidEvaluationGuardian guardianForEval = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)field, null, (boolean)false, (ELManager)manager);
                    guardianForEval.updateElements((IRfNamedElement)field, (IRfNamedElement)coverpoint);
                    int[] dimensions = this.getDimensions(coverpointExpression, field, guardianForSize, guardianForEval, emptyEvaluator);
                    if (dimensions == null || dimensions.length % 2 != 0) continue;
                    coverpoint.visitHidObject(null, new BinsDeclarationVisitor(LintUtils.getNamedElementFullName(field), dimensions));
                }
            }
            ++n2;
        }
    }

    private int[] getDimensions(IHidObject hidObject, RfField field, IHidEvaluationGuardian guardianForSize, IHidEvaluationGuardian guardianForEval, ELParamValuesHidEvaluator evaluator) {
        IELParamValue paramValueForSize = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)hidObject, (IHidEvaluator)evaluator, (IRfNamedElement)field, (IHidEvaluationGuardian)guardianForSize));
        if (ELUtils.isUnsuccessfulEval((IELParamValue)paramValueForSize)) {
            return this.getUnsuccessfulEvaluationDimensions(field, evaluator, guardianForEval);
        }
        return this.getSuccesfulEvaluationDimensions(paramValueForSize);
    }

    private int[] getUnsuccessfulEvaluationDimensions(RfField field, ELParamValuesHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        DataType dataType = LintUtils.getAssociatedFinalDataType(field).getAssocDataType();
        if (dataType == null) {
            return null;
        }
        List<IndexType> packed = dataType.getPackedDimension();
        if (packed == null || packed.isEmpty()) {
            return null;
        }
        int[] packedDimensions = new int[packed.size() * 2];
        int i = 0;
        while (i < packed.size()) {
            IndexType indexType = packed.get(i);
            if (!(indexType.getRangeObject() instanceof RfHidOperator)) {
                return null;
            }
            RfHidOperator operator = (RfHidOperator)indexType.getRangeObject();
            if (!operator.isRangeOrPartSelect()) {
                return null;
            }
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return null;
            }
            BitVectorContext dummyContextOrigin = BitVectorContext.of((IRfNamedElement)field.getEnclosingScope(), (boolean)false);
            IELParamValue lhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)operator.getLHValue(), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)lhValue) || !(lhValue instanceof ELParamValues.ParamValueNumber)) {
                return null;
            }
            IELParamValue rhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)rhValues.get(0)), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)rhValue) || !(rhValue instanceof ELParamValues.ParamValueNumber)) {
                return null;
            }
            packedDimensions[i * 2] = lhValue.intValue();
            packedDimensions[i * 2 + 1] = rhValue.intValue();
            ++i;
        }
        return packedDimensions;
    }

    private int[] getSuccesfulEvaluationDimensions(IELParamValue paramValueForSize) {
        DVTNumber numberForSize = paramValueForSize.getDVTNumber();
        while (!(numberForSize instanceof VlogBitVector)) {
            if (numberForSize instanceof DVTUnpackedArray) {
                numberForSize = ((DVTUnpackedArray)numberForSize).getElementType();
                continue;
            }
            return null;
        }
        VlogBitVector bitVector = (VlogBitVector)numberForSize;
        return (int[])bitVector.getArrayDimensions().clone();
    }

    public Integer getHidImplicitIntValue(RfHidImplicit hidObject) {
        ELParamValueScope hidValue = ELUtils.evaluate((IHidObject)hidObject, (IHidEvaluator)new IHidEvaluator.NullHidEvaluator(), null, (IHidEvaluationGuardian)IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN);
        if (ELUtils.isUnsuccessfulEval((ELParamValueScope)hidValue)) {
            return null;
        }
        DVTNumber hidNumber = hidValue.getDVTNumber();
        if (!(hidNumber instanceof VlogBitVector)) {
            return null;
        }
        return hidNumber.intValue();
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class BinsDeclarationVisitor
    implements IHidVisitor<RfHidOperator> {
        private int width;
        private int[] dimensions;
        private String fieldName;
        private ParserPath parserPath;

        public BinsDeclarationVisitor(String fieldName, int[] dimensions) {
            this.fieldName = fieldName;
            this.dimensions = dimensions;
            this.width = 0;
            int i = 0;
            while (i < dimensions.length) {
                int bigDimension = dimensions[i] < dimensions[i + 1] ? dimensions[i + 1] : dimensions[i];
                int smallDimension = dimensions[i] < dimensions[i + 1] ? dimensions[i] : dimensions[i + 1];
                this.width += Math.abs(bigDimension - smallDimension) + 1;
                i += 2;
            }
        }

        public boolean visit(RfHidOperator hidOperator) {
            if (!hidOperator.isCovergroupRangeList()) {
                return true;
            }
            ListContainer rhHids = hidOperator.getRHValues();
            if (rhHids == null || rhHids.isEmpty()) {
                return true;
            }
            for (IHidObject hidObject : rhHids) {
                if (hidObject instanceof RfHidImplicit) {
                    this.checkValue((RfHidImplicit)hidObject, hidOperator);
                }
                if (!(hidObject instanceof RfHidOperator) || !((RfHidOperator)hidObject).isRangeOrPartSelect()) continue;
                this.checkRange((RfHidOperator)hidObject, hidOperator);
            }
            return true;
        }

        public void checkValue(RfHidImplicit hidObject, RfHidOperator hidOperator) {
            int value = Check_R_1333.this.getHidImplicitIntValue(hidObject);
            if (32 - Integer.numberOfLeadingZeros(value) > this.width) {
                Check_R_1333.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), "Field '" + this.fieldName + "' has range " + this.getDimensions() + ", so value " + value + " is not within the possible values!");
            }
        }

        private String getDimensions() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.dimensions.length) {
                sb.append("[").append(this.dimensions[i]).append(":").append(this.dimensions[i + 1]).append("]");
                i += 2;
            }
            return sb.toString();
        }

        public void checkRange(RfHidOperator hidObject, RfHidOperator hidOperator) {
            IHidObject lhHid = hidObject.getLHValue();
            IHidObject rhHid = hidObject.getFirstRHValue();
            if (!(lhHid instanceof RfHidImplicit) || !(rhHid instanceof RfHidImplicit)) {
                return;
            }
            Integer smallValue = Check_R_1333.this.getHidImplicitIntValue((RfHidImplicit)lhHid);
            Integer bigValue = Check_R_1333.this.getHidImplicitIntValue((RfHidImplicit)rhHid);
            if (smallValue == null || bigValue == null) {
                return;
            }
            if (smallValue > bigValue) {
                int aux = smallValue;
                smallValue = bigValue;
                bigValue = aux;
            }
            if (32 - Integer.numberOfLeadingZeros(bigValue) > this.width) {
                int firstValue = (int)Math.pow(2.0, this.width);
                if (firstValue < smallValue) {
                    firstValue = smallValue;
                }
                Check_R_1333.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), "Field '" + this.fieldName + "' has range " + this.getDimensions() + ", so value" + (firstValue == bigValue ? " " + firstValue + " is" : "s [" + firstValue + " : " + bigValue + "] are") + " not within the possible values!");
            }
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }
    }
}

