/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.19")
@CheckID(value="R.1334")
@CheckName(value="R.1334")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.RANGE})
@CheckTitle(value="Inside ranges must be [low:high]")
@CheckDescription(value="If the bound to the left of the colon is greater than the bound to the right, the range is empty and contains no values.\n\nExample:\nfoo inside {[0:7]};   //allowed\nfoo2 inside {[15:0]}; //not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1334
extends OVMComplianceCheck {
    public Check_R_1334(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (!(hidOperator instanceof RfHidOperator)) {
                    return true;
                }
                Check_R_1334.this.notifyCheckAlive();
                if (!hidOperator.isInsideSet()) {
                    return true;
                }
                if (Check_R_1334.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                ListContainer rhValues = hidOperator.getRHValues();
                for (IHidObject rhValue : rhValues) {
                    int rhInt;
                    int lhInt;
                    if (!(rhValue instanceof RfHidOperator)) {
                        return true;
                    }
                    if (!((RfHidOperator)rhValue).isRangeOrPartSelect()) {
                        return true;
                    }
                    IHidObject left = ((RfHidOperator)rhValue).getLHValue();
                    IHidObject right = (IHidObject)((RfHidOperator)rhValue).getRHValues().get(0);
                    String leftValue = null;
                    String rightValue = null;
                    if (!(left instanceof RfHidImplicit)) {
                        if (!(left instanceof RfHid)) {
                            return true;
                        }
                        IRfNamedElement leftElem = ((RfHid)left).getElement();
                        if (!(leftElem instanceof RfField) || !((RfField)leftElem).isParameter()) {
                            return true;
                        }
                        leftValue = ((RfField)leftElem).getInitialValue(false);
                    } else {
                        leftValue = ((RfHidImplicit)left).getName();
                    }
                    if (!(right instanceof RfHidImplicit)) {
                        if (!(right instanceof RfHid)) {
                            return true;
                        }
                        IRfNamedElement rightElem = ((RfHid)right).getElement();
                        if (!(rightElem instanceof RfField) || !((RfField)rightElem).isParameter()) {
                            return true;
                        }
                        rightValue = ((RfField)rightElem).getInitialValue(false);
                    } else {
                        rightValue = ((RfHidImplicit)right).getName();
                    }
                    try {
                        lhInt = Integer.parseInt(leftValue);
                        rhInt = Integer.parseInt(rightValue);
                    }
                    catch (Exception exception) {
                        return true;
                    }
                    if (lhInt <= rhInt) continue;
                    Check_R_1334.this.addHit(this.parserPath, (RfHidOperator)rhValue, ((RfHidOperator)rhValue).getQualifiers(), "Inside range '" + rhValue.toString() + "' must be [low_bound:high_bound]!");
                }
                return true;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

