/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.19")
@CheckID(value="R.1335")
@CheckName(value="R.1335")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.CONDITIONAL, RuleLabel.PERFORMANCE})
@CheckTitle(value="Do not call a method unconditionally then check within the method whether to do anything")
@CheckDescription(value="This rule checks that there are no methods that exit on the first statement based on the value of a parameter.\nInstead have a conditional statement in the calling code to decide whether or not to call the function or task. Simply calling a function or task incurs a cost due to stack.\n\nExample:\n\nfunction foo(int arg)\n  if (arg == 1) return 0;  // not allowed\nendfunction\n\nif (var != 1)\n  foo(var);  // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1335
extends OVMComplianceCheck {
    List<RfNamedElement> methods;
    Map<RfFunction, Integer> offsetOfReturnCondition;
    boolean isFirst;

    public Check_R_1335(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.offsetOfReturnCondition = new HashMap<RfFunction, Integer>();
        this.methods = this.fOVMProject.getAllFunctions().stream().filter(e -> !((RfFunction)e).getArguments().isEmpty() && !e.isPredefined()).collect(Collectors.toList());
        this.methods.addAll(this.fOVMProject.getAllTasks().stream().filter(e -> !((RfFunction)e).getArguments().isEmpty() && !e.isPredefined()).collect(Collectors.toList()));
        for (RfNamedElement method : this.methods) {
            RfDefElement declaration;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(method.getFile().getParserPath())) {
                return;
            }
            if (!(method instanceof RfFunction) || (declaration = ((RfFunction)method).getDeclaration()) == null || declaration.getReparseInfo() != null) continue;
            method.visitHidObject(null, new ConditionalStatementVisitor((RfFunction)method, ((RfFunction)method).getArguments()));
            if (!this.offsetOfReturnCondition.containsKey(method)) continue;
            method.visitHidObject(null, new FirstStatementVisitor(this.offsetOfReturnCondition.get(method)));
            if (!this.isFirst) continue;
            this.addHit(method, "Method '" + LintUtils.getNamedElementFullName(method) + "' exits immediatelly, depending on argument value. Have the condition in the calling code!");
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class ConditionalStatementVisitor
    implements IHidVisitor<RfHidOperator> {
        RfFunction method;
        List<IRfFieldElement> methodArguments;
        private RfNamedElement scope;
        private boolean argUsage;

        public ConditionalStatementVisitor(RfFunction method, List<IRfFieldElement> methodArguments) {
            this.method = method;
            this.methodArguments = methodArguments;
            this.argUsage = false;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(RfHidOperator hidOp) {
            if (this.argUsage) {
                return false;
            }
            if (hidOp.getOperatorText().equals("return")) {
                if (!(this.scope instanceof RfActionBlock) || !((RfActionBlock)this.scope).isIf()) {
                    return true;
                }
                IHidObject condition = ((RfActionBlock)this.scope).getConditionalBlockExpression();
                if (!(condition instanceof RfHidOperator)) {
                    return true;
                }
                Set conditionHids = HidUtils.flattenToHids((IHidObject)condition, (Set)HidFlatteningOption.IMPLICITS_AND_SELECT_OBJECTS_EXCLUDED);
                Set conditionElements = conditionHids.stream().map(IHid::getElement).collect(Collectors.toSet());
                for (IRfFieldElement arg : this.methodArguments) {
                    if (!conditionElements.contains(arg)) continue;
                    this.argUsage = true;
                    Check_R_1335.this.offsetOfReturnCondition.put(this.method, ((RfHidOperator)condition).getOpenBoundary());
                    return false;
                }
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    private class FirstStatementVisitor
    implements IHidVisitor<RfHid> {
        int offset;

        public FirstStatementVisitor(Integer offset) {
            this.offset = offset;
            Check_R_1335.this.isFirst = true;
        }

        public boolean visit(RfHid hid) {
            if (!Check_R_1335.this.isFirst) {
                return false;
            }
            if (hid.getOffset() < this.offset) {
                Check_R_1335.this.isFirst = false;
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

