/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.19")
@CheckID(value="R.1336")
@CheckName(value="R.1336")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.TEST, RuleLabel.VERIFICATION, RuleLabel.PHASE})
@CheckTitle(value="Topology should be printed in 'end_of_elaboration_phase' in tests")
@CheckDescription(value="This check flags test classes that do not call the 'print_topology' method in 'end_of_elaboration_phase'.\nThe topology is a useful debug information to see the test is working as expected.\n\nExamples:\n\nclass my_test_1 extends uvm_test;\t\t\t\t\t\t\t// not allowed\n\n\tvirtual function void end_of_elaboration_phase(uvm_phase phase);\n\t\t// implementation\n\tendfunction\n\nendclass\n\nclass my_test_2 extends uvm_test;\t\t\t\t\t\t\t// allowed\n\n\tvirtual function void end_of_elaboration_phase(uvm_phase phase);\n\t\tuvm_top.print_topology();\n\tendfunction\n\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1336
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Method ''end_of_elaboration_phase'' of test ''{0}'' must call ''print_topology''!";
    private static final String ERROR_MESSAGE_METHOD_DOES_NOT_EXIST = "Method ''end_of_elaboration_phase'' of test ''{0}'' must exist and call ''print_topology''!";
    private static final String ERROR_MESSAGE_NOT_GUARDED = "Method ''end_of_elaboration_phase'' of test ''{0}'' must check the max verbosity level before calling ''print_topology''!";
    private static final String VERBOSITY_VARIABLE = "uvm_pkg::uvm_report_handler.m_max_verbosity_level";
    private static final String VERBOSITY_METHOD = "uvm_pkg::uvm_report_object.get_report_max_verbosity_level";
    @CheckParameter(defaultValue="false", description="When true the rule will also check that the print call is guarded by a check of the verbosity level. The existence of the get_report_max_verbosity_level method call or m_max_verbosity_level in the if expression is checked.", name="checkForVerbosityLevelGuard", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pCheckForVerbosityLevelGuard;

    public Check_R_1336(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmTest == null) {
            return;
        }
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmTest)) {
            RfFileDef file;
            if (!(rfNamedElement instanceof RfClass) || (file = rfNamedElement.getFile()) == null || this.checkPreWaivers(file.getParserPath())) continue;
            this.notifyCheckAlive();
            RfFunction phase = rfNamedElement.getFunctionWithPrefix("end_of_elaboration_phase", 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (phase == null) {
                this.addHit(rfNamedElement, MessageFormat.format(ERROR_MESSAGE_METHOD_DOES_NOT_EXIST, rfNamedElement.getName()));
                continue;
            }
            LocalHidVisitor phaseVisitor = new LocalHidVisitor();
            phase.visitHidObject(null, phaseVisitor);
            if (phaseVisitor.foundPrintCall) continue;
            if (this.pCheckForVerbosityLevelGuard && phaseVisitor.isNotGuarded) {
                this.addHit(rfNamedElement, MessageFormat.format(ERROR_MESSAGE_NOT_GUARDED, rfNamedElement.getName()));
                continue;
            }
            this.addHit(rfNamedElement, MessageFormat.format(ERROR_MESSAGE, rfNamedElement.getName()));
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class LocalHidVisitor
    extends RfHidVisitor {
        private boolean foundPrintCall;
        private boolean isNotGuarded;

        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hid) {
            if (this.foundPrintCall) {
                return false;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            if (!(hid.getElement() instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)hid.getElement();
            if (!function.getName().equals("print_topology")) {
                return true;
            }
            RfNamedElement functionScope = function.getEnclosingScope();
            if (!LintUtils.getNamedElementFullName(functionScope).equals("uvm_pkg::uvm_root")) {
                return true;
            }
            IRfNamedElement holderScope = ((HidHolder)this.holder).getScope();
            if (holderScope == null) {
                return true;
            }
            if (Check_R_1336.this.pCheckForVerbosityLevelGuard) {
                RfActionBlock actionBlock = (RfActionBlock)holderScope.getEnclosingScope(RfActionBlock.class);
                while (actionBlock != null) {
                    IHidObject expression = actionBlock.getConditionalBlockExpression();
                    Set hids = HidUtils.flattenToUniqueHids((IHidObject)expression, (Set)HidFlatteningOption.IMPLICITS_SELECTS_AND_ARGS_EXCLUDED);
                    for (IHid hidInCondition : hids) {
                        if (!(hidInCondition instanceof RfHid)) continue;
                        IRfNamedElement hidElement = hidInCondition.getElement();
                        String fullName = null;
                        if (hidElement instanceof RfField) {
                            fullName = ((RfField)hidElement).getFullName();
                        }
                        if (hidElement instanceof RfFunction) {
                            fullName = ((RfFunction)hidElement).getFullName();
                        }
                        if (fullName == null || !fullName.equals(Check_R_1336.VERBOSITY_METHOD) && !fullName.equals(Check_R_1336.VERBOSITY_VARIABLE)) continue;
                        this.foundPrintCall = true;
                        this.isNotGuarded = false;
                        return false;
                    }
                    actionBlock = actionBlock.getEnclosingScope().getEnclosingScope(RfActionBlock.class);
                }
                this.isNotGuarded = true;
                return true;
            }
            this.foundPrintCall = true;
            return false;
        }
    }
}

