/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.19")
@CheckID(value="R.1337")
@CheckName(value="R.1337")
@CheckLabel(labels={RuleLabel.PERFORMANCE, RuleLabel.REGISTER, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use backdoor access repeatedly to read register information")
@CheckDescription(value="The performance drops significantly when backdoor accesses are repeteadly used to read register information.\nBackdoor register read inside loops without letting time pass can lead to performance issues.\nLoops that have time consuming statements (delay, tasks called) will not be flagged.\nAn alternative solution to this situation would be to use the uvm_reg.get_mirrored_value.\n\nExamples:\n\nfor(int i; i < 10; i++)\n  reg.read(e, rdata, UVM_BACKDOOR);  // NOT ALLOWED\n\nfor(int i; i < 10; i++) begin\n  #10;\n  reg.read(e, rdata, UVM_BACKDOOR);  // ALLOWED\nend\n\nCheck supports pre-waiving.")
public class Check_R_1337
extends OVMComplianceCheck {
    private RfClass registerClass;

    public Check_R_1337(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.registerClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_reg"), true);
        if (this.registerClass == null) {
            return;
        }
        List loops = this.fOVMProject.getRfProject().getAllActionBlocks().stream().filter(RfActionBlock::isLoop).collect(Collectors.toList());
        for (RfActionBlock loop : loops) {
            boolean hasBackdoorRead;
            if (this.checkPreWaivers(loop.getFile().getParserPath())) continue;
            this.notifyCheckAlive();
            LocalIterationVariablesVisitor loopIterationVariablesVisitor = null;
            if (loop.isForOrForeach()) {
                loopIterationVariablesVisitor = new LocalIterationVariablesVisitor();
                loop.visitHidObject(null, loopIterationVariablesVisitor);
            }
            List<IRfNamedElement> loopIterationVariables = loopIterationVariablesVisitor != null ? loopIterationVariablesVisitor.getLoopIterationVariables() : null;
            LocalLoopBackdoorVisitor loopBackdoorVisitor = new LocalLoopBackdoorVisitor(loopIterationVariables);
            loop.visitHidObject(null, loopBackdoorVisitor);
            Map<IRfNamedElement, List<DVTPair<RfHid, ParserPath>>> backdoorReads = loopBackdoorVisitor.getBackdoorReads();
            boolean bl = hasBackdoorRead = !backdoorReads.isEmpty();
            if (!hasBackdoorRead) continue;
            LocalTimeConsumingVisitor timeConsumingVisitor = new LocalTimeConsumingVisitor(backdoorReads);
            loop.visitHidObject(null, timeConsumingVisitor);
            boolean hasTimeConsuming = timeConsumingVisitor.hasTimeConsuming();
            if (hasTimeConsuming) continue;
            for (Map.Entry<IRfNamedElement, List<DVTPair<RfHid, ParserPath>>> entry : backdoorReads.entrySet()) {
                for (DVTPair<RfHid, ParserPath> backdoorRead : entry.getValue()) {
                    this.addHit((ParserPath)backdoorRead.getValue(), ((RfHid)((Object)backdoorRead.getKey())).getOccurrence(), "Backdoor access '" + HidUtils.toNiceString((IHidObject)((IHidObject)backdoorRead.getKey())) + "' is used inside a loop!");
                }
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalIterationVariablesVisitor
    implements IHidVisitor<RfHidOperator> {
        List<IRfNamedElement> loopIterationVariables = new ArrayList<IRfNamedElement>();

        public boolean visit(RfHidOperator hidObject) {
            if (!hidObject.isForStep() && !hidObject.isForeachCondition()) {
                return true;
            }
            if (hidObject.isForStep()) {
                IHidObject lhValue = hidObject.getLHValue();
                if (!(lhValue instanceof RfHidOperator)) {
                    return true;
                }
                IHidObject lhHid = ((RfHidOperator)lhValue).getLHValue();
                if (lhHid == null) {
                    return true;
                }
                if (!(lhHid instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement lhHidElement = ((RfHid)lhHid).getElement();
                if (lhHidElement == null) {
                    return true;
                }
                this.loopIterationVariables.add(lhHidElement);
            } else if (hidObject.isForeachCondition()) {
                IHidObject lhValue = hidObject.getLHValue();
                if (!(lhValue instanceof RfHidAccess)) {
                    return true;
                }
                List selects = ((RfHidAccess)lhValue).getSelects();
                if (selects.size() != 1) {
                    return true;
                }
                IHidObject accessedIndex = (IHidObject)selects.get(0);
                if (accessedIndex == null) {
                    return true;
                }
                if (!(accessedIndex instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement accessedIndexElement = ((RfHid)accessedIndex).getElement();
                if (accessedIndexElement == null) {
                    return true;
                }
                this.loopIterationVariables.add(accessedIndexElement);
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }

        public List<IRfNamedElement> getLoopIterationVariables() {
            return this.loopIterationVariables;
        }
    }

    private class LocalLoopBackdoorVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;
        Map<IRfNamedElement, List<DVTPair<RfHid, ParserPath>>> backdoorReads = new HashMap<IRfNamedElement, List<DVTPair<RfHid, ParserPath>>>();
        List<IRfNamedElement> loopIterationVariables;

        public LocalLoopBackdoorVisitor(List<IRfNamedElement> loopIterationVariables) {
            this.loopIterationVariables = loopIterationVariables;
        }

        private IRfNamedElement getRegisterElement(RfHid backdoorReadHid) {
            HidAccess parentAccess = backdoorReadHid.getParentAccess();
            if (parentAccess == null) {
                return null;
            }
            Hid parentHid = parentAccess.getParentHid();
            if (parentHid == null) {
                return null;
            }
            IRfNamedElement register = parentHid.getElement();
            if (register == null) {
                return null;
            }
            return register;
        }

        private void addBackdoorReadToMap(RfHid hid, IRfNamedElement registerElement) {
            if (!this.backdoorReads.containsKey(registerElement)) {
                this.backdoorReads.put(registerElement, new ArrayList());
            }
            this.backdoorReads.get(registerElement).add((DVTPair<RfHid, ParserPath>)new DVTPair((Object)hid, (Object)this.parserPath));
        }

        public boolean visit(RfHid hid) {
            IRfNamedElement accessedIndexElement;
            if (!(hid.getElement() instanceof RfFunction)) {
                return true;
            }
            if (!"read".equals(hid.getName())) {
                return true;
            }
            HidAccess parrentAccess = hid.getParentAccess();
            if (parrentAccess == null) {
                return true;
            }
            IRfNamedElement parrentAssociatedType = parrentAccess.getAssociatedType();
            if (!(parrentAssociatedType instanceof RfClass)) {
                return true;
            }
            if (!LintUtils.isSubClassOf((RfClass)parrentAssociatedType, Check_R_1337.this.registerClass)) {
                return true;
            }
            LintUtils.PathType accessType = LintUtils.getAccessType(hid, hid.getName());
            if (accessType != LintUtils.PathType.BACKDOOR) {
                return true;
            }
            IRfNamedElement registerElement = this.getRegisterElement(hid);
            if (this.loopIterationVariables == null || this.loopIterationVariables.size() != 1) {
                this.addBackdoorReadToMap(hid, registerElement);
                return true;
            }
            List selects = parrentAccess.getSelects();
            if (selects == null || selects.size() != 1) {
                this.addBackdoorReadToMap(hid, registerElement);
                return true;
            }
            IHidObject accessedIndex = (IHidObject)selects.get(0);
            if (!(accessedIndex instanceof RfHid)) {
                this.addBackdoorReadToMap(hid, registerElement);
                return true;
            }
            IRfNamedElement loopIterationElement = this.loopIterationVariables.get(0);
            if (loopIterationElement.equals(accessedIndexElement = ((RfHid)accessedIndex).getElement())) {
                return true;
            }
            this.addBackdoorReadToMap(hid, registerElement);
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Map<IRfNamedElement, List<DVTPair<RfHid, ParserPath>>> getBackdoorReads() {
            return this.backdoorReads;
        }
    }

    private final class LocalTimeConsumingVisitor
    implements IHidVisitor<IHidObject> {
        boolean hasTimeConsuming = false;
        Map<IRfNamedElement, List<DVTPair<RfHid, ParserPath>>> backdoorReads;

        public LocalTimeConsumingVisitor(Map<IRfNamedElement, List<DVTPair<RfHid, ParserPath>>> backdoorReads) {
            this.backdoorReads = backdoorReads;
        }

        private boolean isTask(IHidObject hidObject) {
            if (!(hidObject instanceof RfHidAccess)) {
                return false;
            }
            RfHidAccess hidAccess = (RfHidAccess)hidObject;
            if (!(hidAccess.getParentHid() instanceof RfHid)) {
                return false;
            }
            RfHid hid = (RfHid)hidAccess.getParentHid();
            if (!(hid.getElement() instanceof RfFunction)) {
                return false;
            }
            RfFunction function = (RfFunction)hid.getElement();
            return function.isTask() && !function.getFullName().equals("uvm_pkg::uvm_reg.read");
        }

        private final boolean isDelayOrWait(IHidObject hidObject) {
            if (!(hidObject instanceof RfHidOperator)) {
                return false;
            }
            RfHidOperator hidOperator = (RfHidOperator)hidObject;
            return hidOperator.isEventControl() || hidOperator.isWaitEventControl() || hidOperator.isVlogDelayControlStatement() || hidOperator.isPoundPound();
        }

        private IRfNamedElement getRegisterElementIfReassigned(IHidObject hidObject) {
            switch (hidObject.getHidKind()) {
                case OPERATOR: {
                    IHidObject lhValue;
                    HidOperator operator = (HidOperator)hidObject;
                    if (!operator.isAssignment()) {
                        return null;
                    }
                    if (operator.hasOccurrence(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER)) {
                        ISDataAbstract resolvedType = operator.getOperatorResolvedType();
                        if (resolvedType == null) {
                            return null;
                        }
                        if (!(resolvedType instanceof SDataVariable)) {
                            return null;
                        }
                        IRfNamedElement declarationAssignElement = ((SDataVariable)resolvedType).getVariable();
                        if (declarationAssignElement == null) {
                            return null;
                        }
                        if (this.backdoorReads.containsKey(declarationAssignElement)) {
                            return declarationAssignElement;
                        }
                    }
                    if ((lhValue = operator.getLHValue()) == null) {
                        return null;
                    }
                    if (!(lhValue instanceof RfHid)) {
                        return null;
                    }
                    IRfNamedElement lhElement = ((RfHid)lhValue).getElement();
                    if (lhElement == null) {
                        return null;
                    }
                    if (!this.backdoorReads.containsKey(lhElement)) break;
                    return lhElement;
                }
                case HID: {
                    Hid hid = (Hid)hidObject;
                    if (!hid.isMethodCall(false)) {
                        return null;
                    }
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                    for (MethodCall methodCall : methodCalls) {
                        if (methodCall.argumentValuesMapRaw == null) continue;
                        for (Map.Entry argument : methodCall.argumentValuesMapRaw.entrySet()) {
                            IRfNamedElement argumentElement;
                            IHidObject argumentHid = (IHidObject)argument.getValue();
                            IRfFieldElement argumentField = (IRfFieldElement)argument.getKey();
                            if (!argumentField.isInout() && !argumentField.isOutput() || !(argumentHid instanceof RfHid) || (argumentElement = ((RfHid)argumentHid).getElement()) == null || !this.backdoorReads.containsKey(argumentElement)) continue;
                            return argumentElement;
                        }
                    }
                    break;
                }
            }
            return null;
        }

        public boolean visit(IHidObject hidObject) {
            if (this.isTask(hidObject) || this.isDelayOrWait(hidObject) || this.hasTimeConsuming) {
                this.hasTimeConsuming = true;
                return false;
            }
            IRfNamedElement reassignedRegisterElement = this.getRegisterElementIfReassigned(hidObject);
            if (reassignedRegisterElement != null) {
                this.backdoorReads.remove(reassignedRegisterElement);
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        public boolean hasTimeConsuming() {
            return this.hasTimeConsuming;
        }
    }
}

