/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.Check_R_1002;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;

@CheckVersion(value="24.1.19")
@CheckID(value="R.1338")
@CheckName(value="R.1338")
@CheckLabel(labels={RuleLabel.RANDOMIZATION, RuleLabel.FIELD})
@CheckTitle(value="Do not declare rand real variables")
@CheckDescription(value="This check flags any rand real variables declared in the project.\nSome simulators do not support real type for rand variables.\n\nExamples:\nrand real a; // not allowed\nrand real b; // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1338
extends Check_R_1002 {
    public Check_R_1338(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfStruct[] allStructs;
        int n;
        RfClass[] allClasses = this.fOVMProject.getRfProject().getAllClasses();
        if (allClasses != null) {
            RfClass[] rfClassArray = allClasses;
            n = allClasses.length;
            int n2 = 0;
            while (n2 < n) {
                RfClass clazz = rfClassArray[n2];
                clazz.accept(null, this.visitor);
                ++n2;
            }
        }
        if ((allStructs = this.fOVMProject.getRfProject().getAllStructsUnions()) != null) {
            RfStruct[] rfStructArray = allStructs;
            int n3 = allStructs.length;
            n = 0;
            while (n < n3) {
                RfStruct struct = rfStructArray[n];
                struct.accept(null, this.visitor);
                ++n;
            }
        }
    }

    @Override
    public String getMessage() {
        return " rand";
    }

    @Override
    public boolean checkVariable(RfNamedElement namedElement) {
        return (namedElement.isRand() || namedElement.isRandc()) && this.isReal(namedElement);
    }
}

