/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.19")
@CheckID(value="R.1339")
@CheckName(value="R.1339")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.DELAY, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not use negative delay")
@CheckDescription(value="This check flags usages of negative delay, since negative values from a simulation time perspective don't make sense and it's usually a bug.\nThe rule checks the value of implicit numbers and basic arithmetic operations of numbers, but not variable values.\n\nExamples:\n#10;\t\t\t\t\t// allowed\n#(-1us);\t\t\t\t// not allowed\n#(-2 * (1ms));\t\t// not allowed\n#(5 - 15);\t\t\t// not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1339
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Delay with negative value ''{0}'' is used!";

    public Check_R_1339(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final ELManager manager = this.fOVMProject.getRfProject().getELManager();
        final ELParamValuesHidEvaluator evaluator = ELParamValues.EMPTY.getHidEvaluator(manager);
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (Check_R_1339.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (!(hidOperator instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator operator = (RfHidOperator)hidOperator;
                if (!operator.hasOccurrence(HidOperatorQualifier.IS_DELAY_CONTROL)) {
                    return true;
                }
                Check_R_1339.this.notifyCheckAlive();
                IHidObject hidObject = hidOperator.getLHValue();
                BitVectorContext context = BitVectorContext.of((IRfNamedElement)this.scope, (boolean)false);
                IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)this.scope, null, (boolean)false, (ELManager)manager);
                IELParamValue delayValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)hidObject, (IHidEvaluator)evaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)delayValue) || !(delayValue instanceof ELParamValues.ParamValueNumber)) {
                    return true;
                }
                if (delayValue.intValue() >= 0) {
                    return true;
                }
                Check_R_1339.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), MessageFormat.format(Check_R_1339.ERROR_MESSAGE, HidUtils.toNiceString((IHidObject)hidObject)));
                return true;
            }
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

