/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractOperatorInConstraint;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.2.23")
@CheckID(value="R.1340")
@CheckName(value="R.1340")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.CONSTRAINT, RuleLabel.COMPARISON})
@CheckTitle(value="Do not use operators with lower precedence as comparison operands in constraints")
@CheckDescription(value="This check flags relational operators used with other operators of lower precedence without the use of parenthesis because doing so can lead to unexpected behavior.\nRelational operators are considered the following: '==', '!=', '>', '<', '>=', '<='\n\nExamples:\n\nconstraint level_c { a & b == c; }   // not allowed\nconstraint level_c { (a & b) == c; } // allowed\n\n\nCheck supports pre-waiving.")
public class Check_R_1340
extends AbstractOperatorInConstraint {
    @CheckParameter(defaultValue="", description="Comma separated list of low precedence operators to be skipped.", name="skipOperators", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipOperators;
    private static final List<String> operatorList = Arrays.asList("&", "^", "~^", "^~", "|", "&&", "||", "->", "<->", "=", "+=", "-=", "*=", "/=", "%=", "&=", "^=", "|=", "<<=", ">>=", "<<<=", ">>>=", ":=", ":/", "<=");
    private static final Set<Integer> OPERATOR_TYPE_HIGH_PRIORITY = new HashSet<Integer>(Arrays.asList(482, 483, 486, 487, 488, 489));
    private static final Set<Integer> OPERATOR_TYPE_LOW_PRIORITY = new HashSet<Integer>(Arrays.asList(471, 473, 475, 476, 498, 480, 481, 535, 534, 499, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 520, 513, 514));

    @Override
    public void configure() {
        super.configure();
        for (String operator : this.pSkipOperators) {
            if (operatorList.contains(operator)) continue;
            this.signalParamError("Operator '" + operator + "' is not a low priority operator!", true);
        }
    }

    public Check_R_1340(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkOperators(RfHidOperator op, List<IHidObject> hidValues, HashMap<RfHidOperator, String> hits, ParserPath parserPath) {
        if (hidValues.isEmpty()) {
            return;
        }
        boolean operatorTypeHigh = OPERATOR_TYPE_HIGH_PRIORITY.contains(op.getOperatorType());
        boolean operatorTypeLow = OPERATOR_TYPE_LOW_PRIORITY.contains(op.getOperatorType()) && !this.pSkipOperators.contains(op.getOperatorText());
        for (IHidObject hid : hidValues) {
            if (!(hid instanceof RfHidOperator) || !this.checkOperators((RfHidOperator)hid, operatorTypeHigh, operatorTypeLow) || this.checkParanthesisParity(op, (RfHidOperator)hid, parserPath)) continue;
            hits.put(op, "Constraint expression '" + HidUtils.toString((IHidObject)op, (boolean)true, (boolean)true) + "' contains a relational operator with lower precedence operator!");
            return;
        }
    }

    private boolean checkOperators(RfHidOperator hid, boolean operatorTypeHigh, boolean operatorTypeLow) {
        return operatorTypeHigh && OPERATOR_TYPE_LOW_PRIORITY.contains(hid.getOperatorType()) && !this.pSkipOperators.contains(hid.getOperatorText()) || operatorTypeLow && OPERATOR_TYPE_HIGH_PRIORITY.contains(hid.getOperatorType());
    }
}

