/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.21")
@CheckID(value="R.1341")
@CheckName(value="R.1341")
@CheckLabel(labels={RuleLabel.DUPLICATE_CODE, RuleLabel.ASSIGNMENT})
@CheckTitle(value="Duplicate assignments")
@CheckDescription(value="Assigning the same value to a variable multiple times could be a copy/paste error.\nThis rule checks inside modules for all types of duplicate assignments of variables.\n\nCheck supports pre-waiving.")
public class Check_R_1341
extends OVMComplianceCheck {
    Map<RfNamedElement, List<Assignment>> uniqueContinuousAssignments;
    Map<RfNamedElement, List<Assignment>> uniqueDeclarationAssignments;
    Map<RfNamedElement, List<Assignment>> uniqueBlockingAssignments;
    Map<RfNamedElement, List<Assignment>> uniqueNonBlockingAssignments;

    public Check_R_1341(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.uniqueContinuousAssignments = new HashMap<RfNamedElement, List<Assignment>>();
        this.uniqueDeclarationAssignments = new HashMap<RfNamedElement, List<Assignment>>();
        this.uniqueBlockingAssignments = new HashMap<RfNamedElement, List<Assignment>>();
        this.uniqueNonBlockingAssignments = new HashMap<RfNamedElement, List<Assignment>>();
        for (final RfNamedElement module : this.fOVMProject.getAllModules()) {
            this.uniqueContinuousAssignments.put(module, new ArrayList());
            this.uniqueDeclarationAssignments.put(module, new ArrayList());
            this.uniqueBlockingAssignments.put(module, new ArrayList());
            this.uniqueNonBlockingAssignments.put(module, new ArrayList());
            module.visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){
                private HidOperator currentDriveStrength;
                private HidOperator currentDelayControl;
                private IRfNamedElement scope;

                public void setScope(IRfNamedElement scope) {
                    this.scope = scope;
                }

                public boolean visit(HidOperator operator) {
                    RfFunction function;
                    boolean isComplete = operator.isComplete();
                    if (!isComplete) {
                        return true;
                    }
                    if (operator.isDriveStrength()) {
                        this.currentDriveStrength = operator;
                        return true;
                    }
                    if (operator.isVlogDelayControlStatement()) {
                        this.currentDelayControl = operator;
                        return true;
                    }
                    if (!(operator instanceof RfHidOperator)) {
                        return true;
                    }
                    Check_R_1341.this.notifyCheckAlive();
                    if (Check_R_1341.this.checkPreWaivers(this.parserPath)) {
                        return true;
                    }
                    if (this.scope instanceof RfFunction && (function = (RfFunction)this.scope).isExtern()) {
                        int startOffset = function.getDeclaration().getStartOffset();
                        int endOffset = function.getDeclaration().getEndOffset();
                        if (operator.getOffset() > startOffset && operator.getOffset() < endOffset) {
                            return true;
                        }
                    }
                    if (operator.hasQualifier(HidOperatorQualifier.IS_CONTINUOUS_ASSIGN.value()) || operator.hasQualifier(HidOperatorQualifier.IS_PROCEDURAL_CONTINUOUS_ASSIGN.value())) {
                        assignments = Check_R_1341.this.uniqueContinuousAssignments.get(module);
                        if (!this.isDuplicate(operator, assignments)) {
                            Check_R_1341.this.uniqueContinuousAssignments.get(module).add(new Assignment(operator, this.scope, this.currentDelayControl, this.currentDriveStrength, this.parserPath));
                        }
                        this.currentDriveStrength = null;
                        this.currentDelayControl = null;
                    } else if (operator.hasQualifier(HidOperatorQualifier.IS_DECLARATION_ASSIGN.value())) {
                        assignments = Check_R_1341.this.uniqueDeclarationAssignments.get(module);
                        if (!this.isDuplicate(operator, assignments)) {
                            Check_R_1341.this.uniqueDeclarationAssignments.get(module).add(new Assignment(operator, this.scope, this.currentDelayControl, null, this.parserPath));
                        }
                        this.currentDriveStrength = null;
                        this.currentDelayControl = null;
                    } else if (operator.hasQualifier(HidOperatorQualifier.IS_BLOCKING_ASSIGN.value())) {
                        assignments = Check_R_1341.this.uniqueBlockingAssignments.get(module);
                        if (!this.isDuplicate(operator, assignments)) {
                            Check_R_1341.this.uniqueBlockingAssignments.get(module).add(new Assignment(operator, this.scope, this.currentDelayControl, null, this.parserPath));
                        }
                        this.currentDelayControl = null;
                    } else if (operator.hasQualifier(HidOperatorQualifier.IS_NONBLOCKING_ASSIGN.value())) {
                        assignments = Check_R_1341.this.uniqueNonBlockingAssignments.get(module);
                        if (!this.isDuplicate(operator, assignments)) {
                            Check_R_1341.this.uniqueNonBlockingAssignments.get(module).add(new Assignment(operator, this.scope, this.currentDelayControl, null, this.parserPath));
                        }
                        this.currentDelayControl = null;
                    }
                    return true;
                }

                private boolean isDuplicate(HidOperator operator, List<Assignment> assignments) {
                    IHidObject lhValue = operator.getLHValue();
                    ListContainer rhValues = operator.getRHValues();
                    for (Assignment assignment : assignments) {
                        IHidObject currentLhValue = assignment.getOperator().getLHValue();
                        ListContainer currentRhValues = assignment.getOperator().getRHValues();
                        IRfNamedElement currentScope = assignment.getScope();
                        if (!currentLhValue.equals(lhValue) || !currentScope.equals(this.scope) || assignment.getStrength() == null != (this.currentDriveStrength == null) || assignment.getStrength() != null && this.currentDriveStrength != null && !LintUtils.compareExpressions((IHidObject)assignment.getStrength(), (IHidObject)this.currentDriveStrength) || assignment.getDelay() == null != (this.currentDelayControl == null)) continue;
                        if (assignment.getDelay() != null && this.currentDelayControl != null) {
                            HidOperator delay = assignment.getDelay();
                            if (!delay.getOperatorText().equals(this.currentDelayControl.getOperatorText())) continue;
                            IHidObject lhDelay = delay.getLHValue();
                            IHidObject currentLhDelay = this.currentDelayControl.getLHValue();
                            if (!(lhDelay instanceof RfHidImplicit) || !(currentLhDelay instanceof RfHidImplicit) || !((RfHidImplicit)lhDelay).getName().equals(((RfHidImplicit)currentLhDelay).getName())) continue;
                        }
                        if (!LintUtils.compareExpressions((IHidObject)currentRhValues.get(0), (IHidObject)rhValues.get(0))) continue;
                        String hidName = lhValue instanceof RfHid ? LintUtils.getHidFullName((IHid)lhValue) : lhValue.toString();
                        Check_R_1341.this.addHit(this.parserPath, operator, operator.getQualifiers(), "Duplicate assignment of '" + hidName + "' from line " + assignment.getOperator().getLine() + " in file " + Check_R_1341.this.link(LintUtils.getFileShortName(assignment.getPath().path), assignment.getPath().path, assignment.getOperator().getLine()) + "!");
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    static class Assignment {
        private HidOperator operator;
        private IRfNamedElement scope;
        private HidOperator delay;
        private HidOperator strength;
        private ParserPath path;

        public HidOperator getOperator() {
            return this.operator;
        }

        public void setOperator(HidOperator operator) {
            this.operator = operator;
        }

        public IRfNamedElement getScope() {
            return this.scope;
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public HidOperator getDelay() {
            return this.delay;
        }

        public void setDelay(HidOperator delay) {
            this.delay = delay;
        }

        public HidOperator getStrength() {
            return this.strength;
        }

        public void setStrength(HidOperator strength) {
            this.strength = strength;
        }

        public ParserPath getPath() {
            return this.path;
        }

        public void setPath(ParserPath strength) {
            this.path = this.path;
        }

        public Assignment(HidOperator operator, IRfNamedElement scope, HidOperator delay, HidOperator strength, ParserPath path) {
            this.operator = operator;
            this.scope = scope;
            this.delay = delay;
            this.strength = strength;
            this.path = path;
        }
    }
}

