/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;

@CheckVersion(value="24.1.19")
@CheckID(value="R.1342")
@CheckName(value="R.1342")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.PORT, RuleLabel.PARAMETER, RuleLabel.DESIGN})
@CheckTitle(value="Do not use parameters or ports of types that are not SV-VHDL compatible")
@CheckDescription(value="This check flags module parameters or ports of types which are not supported across SV-VHDL.\nThe following types are supported: logic, bit, int/integer, real, enumeration of integer type.\nModules with parameters or ports of unsupported types cannot be instantiated in the VHDL code of a mixed language project.\n\nExamples:\n\nmodule my_module\n    #( parameter shortint p1, // not allowed\n       parameter int p2)      // allowed\n     ( shortint foo,          // not allowed\n       int goo );             // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1342
extends OVMComplianceCheck {
    private final Set<String> supportedTypes = new HashSet<String>(Arrays.asList("bit", "int", "integer", "logic", "real"));

    public Check_R_1342(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfModule[] allModules;
        RfModule[] rfModuleArray = allModules = this.fOVMProject.getRfProject().getAllModules();
        int n = allModules.length;
        int n2 = 0;
        while (n2 < n) {
            RfModule module = rfModuleArray[n2];
            ParserPath parserPath = module.getFile().getParserPath();
            if (!this.checkPreWaivers(parserPath)) {
                this.notifyCheckAlive();
                List<RfField> moduleParameters = module.getParametersWithPrefix("", 384, 2, 1);
                if (moduleParameters != null && !moduleParameters.isEmpty()) {
                    for (RfField parameter : moduleParameters) {
                        CustomTypeInfo typeInfo = this.getCustomTypeInfo(parameter);
                        if (typeInfo == null) continue;
                        if (typeInfo.getDataType().equals(typeInfo.getAssocFinalDataType())) {
                            this.addHit(parameter, "Type '" + typeInfo.getDataType() + "' is not compatible across SV-VHDL!");
                            continue;
                        }
                        this.addHit(parameter, "Custom defined type '" + typeInfo.getDataType() + "' with associated data type '" + typeInfo.getAssocFinalDataType() + "' is not compatible across SV-VHDL!");
                    }
                    module.accept(this.fOVMProject.getRfProject(), new PortDeclarationVisitor());
                }
            }
            ++n2;
        }
    }

    public CustomTypeInfo getCustomTypeInfo(RfAssociatedType element) {
        RfNamedElement assocFinalType = LintUtils.getAssociatedFinalType(element);
        if (assocFinalType == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (assocFinalType instanceof RfStruct) {
            if ((assocFinalType = this.getAssocFinalTypeForEnum((RfStruct)assocFinalType)) == null) {
                return null;
            }
            sb.append(" ");
            sb.append(assocFinalType.getName());
        }
        if (assocFinalType instanceof RfBitVectorScalarType) {
            assocFinalType = ((RfBitVectorScalarType)assocFinalType).getScalarWithDefaultSign();
        }
        if (assocFinalType == null || this.supportedTypes.contains(assocFinalType.getName())) {
            return null;
        }
        DataType dataType = element.getDataType();
        if (dataType == null) {
            return null;
        }
        LintUtils.FullTypeData fullTypeData = LintUtils.getAssociatedFinalDataType(element);
        if (fullTypeData == null || fullTypeData.getAssocDataType() == null) {
            return null;
        }
        sb.insert(0, fullTypeData.getAssocDataType().toString());
        return new CustomTypeInfo(dataType.toString(), sb.toString());
    }

    public RfNamedElement getAssocFinalTypeForEnum(RfStruct element) {
        if (!element.isEnum()) {
            return null;
        }
        if (element.getFile() == null) {
            return null;
        }
        IRfNamedElement enumBaseType = element.getEnumBaseType();
        while (enumBaseType instanceof RfTypeAlias) {
            enumBaseType = ((RfTypeAlias)enumBaseType).getAssociatedType();
        }
        if (!(enumBaseType instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)enumBaseType;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    static class CustomTypeInfo {
        private String dataType;
        private String assocFinalDataType;

        public CustomTypeInfo(String dataType, String assocFinalDataType) {
            this.dataType = dataType;
            this.assocFinalDataType = assocFinalDataType;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getAssocFinalDataType() {
            return this.assocFinalDataType;
        }
    }

    private class PortDeclarationVisitor
    implements IRfNamedElementVisitor {
        private PortDeclarationVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement element) {
            if (!(element instanceof RfPort)) {
                return true;
            }
            if (element.getFile() == null) {
                return true;
            }
            ParserPath parserPath = element.getFile().getParserPath();
            if (Check_R_1342.this.checkPreWaivers(parserPath)) {
                return true;
            }
            Check_R_1342.this.notifyCheckAlive();
            CustomTypeInfo typeInfo = Check_R_1342.this.getCustomTypeInfo((RfAssociatedType)element);
            if (typeInfo == null) {
                return true;
            }
            if (typeInfo.getDataType().equals(typeInfo.getAssocFinalDataType())) {
                Check_R_1342.this.addHit(element, "Type '" + typeInfo.getDataType() + "' is not compatible across SV-VHDL!");
                return true;
            }
            Check_R_1342.this.addHit(element, "Custom defined type '" + typeInfo.getDataType() + "' with associated data type '" + typeInfo.getAssocFinalDataType() + "' is not compatible across SV-VHDL!");
            return true;
        }
    }
}

