/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.20")
@CheckID(value="R.1343")
@CheckName(value="R.1343")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.CONDITIONAL, RuleLabel.COMPARISON})
@CheckTitle(value="Do not use case equality with real operands")
@CheckDescription(value="Case equality (===) and inequality (!==) operators are not allowed for real expressions.\nSome simulators flag such usage of these operators as non-standard.\n\nExamples:\nmodule test;\n  real a, b;\n  initial begin\n    if (a === b)  // not allowed\n    \t$display(\"list_of_arguments\")\n  end\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1343
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Case {0} operator ''{1}'' uses real valued operands!";

    public Check_R_1343(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (Check_R_1343.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                int operatorType = hidOperator.getOperatorType();
                if (operatorType != 484 && operatorType != 485) {
                    return true;
                }
                Check_R_1343.this.notifyCheckAlive();
                IHidObject lhValue = hidOperator.getLHValue();
                IHidObject rhValue = hidOperator.getFirstRHValue();
                if (Check_R_1343.this.checkValue(lhValue) || Check_R_1343.this.checkValue(rhValue)) {
                    String equalityType = operatorType == 484 ? "equality" : "inequality";
                    Check_R_1343.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), MessageFormat.format(Check_R_1343.ERROR_MESSAGE, equalityType, HidUtils.toNiceString((IHidObject)hidOperator)));
                }
                return true;
            }
        });
    }

    public boolean checkValue(IHidObject value) {
        if (value instanceof RfHidImplicit) {
            RfHidImplicit hidImplicit = (RfHidImplicit)value;
            return hidImplicit.getType() == 282;
        }
        if (value instanceof RfHidAccess) {
            RfHidAccess hidAccess = (RfHidAccess)value;
            if (hidAccess.getAssociatedType() == null) {
                return false;
            }
            String associatedType = hidAccess.getAssociatedType().getName();
            return LintUtils.REAL_BASE_TYPES.contains(associatedType);
        }
        if (value instanceof RfHid) {
            RfHid hid = (RfHid)value;
            if (hid.getElement() == null) {
                return false;
            }
            if (!(hid.getElement() instanceof RfField)) {
                return false;
            }
            RfField element = (RfField)hid.getElement();
            return this.isReal(element);
        }
        if (value instanceof RfHidOperator) {
            IRfNamedElement valueType = null;
            ISDataAbstract resolvedType = ((RfHidOperator)value).getOperatorResolvedType();
            if (resolvedType == null) {
                return false;
            }
            ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType);
            if (dataType == null) {
                return false;
            }
            IRfNamedElement iRfNamedElement = valueType = SDataUtils.getUndefinedDataType((ISDataAbstract)dataType) == null ? dataType.getType() : null;
            if (valueType == null) {
                return false;
            }
            return LintUtils.REAL_BASE_TYPES.contains(valueType.getName());
        }
        return false;
    }

    private boolean isReal(RfField element) {
        if (element == null) {
            return false;
        }
        if (element.getDataType() == null) {
            return false;
        }
        if (element.getDataType().getType() == null) {
            return false;
        }
        String type = element.getDataType().getType();
        return LintUtils.REAL_BASE_TYPES.contains(type);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

