/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="24.1.21")
@CheckID(value="R.1344")
@CheckName(value="R.1344")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.METHOD, RuleLabel.WAIT, RuleLabel.EVENT_CONTROL})
@CheckTitle(value="Do not call functions in wait or event control statements")
@CheckDescription(value="This check flags any wait/event control operator that contains a user defined function call.\nFor functions in wait expressions or event controls the LRM only defines a few conditions when the expression must be evaluated to see if the result has changed.\nThis can lead to unexpected behavior.\nPredefined functions are not flagged.\n\nExamples:\n\nwait(foo()); \t\t\t// not allowed\n@(foo());     \t\t// not allowed\nwait(array.size()) \t// allowed\n\nCheck supports pre-waiving.")
public class Check_R_1344
extends OVMComplianceCheck {
    public Check_R_1344(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (Check_R_1344.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1344.this.notifyCheckAlive();
                if (!(hidOperator instanceof RfHidOperator)) {
                    return true;
                }
                if (!hidOperator.isWaitEventControl() && !((RfHidOperator)hidOperator).isEventControl()) {
                    return true;
                }
                IHidObject lhValue = hidOperator.getLHValue();
                ListContainer rhValues = hidOperator.getRHValues();
                if (lhValue == null || rhValues != null) {
                    return true;
                }
                if (this.getAllFunctionCalls(lhValue)) {
                    Check_R_1344.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), String.valueOf(hidOperator.isWaitEventControl() ? "Wait operator '" : "Event operator '") + HidUtils.toNiceString((IHidObject)hidOperator) + "' contains a function call!");
                }
                return true;
            }

            private boolean getAllFunctionCalls(IHidObject hid) {
                Set flattenToHids = HidUtils.flattenToHids((IHidObject)hid, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                for (IHid ihid : flattenToHids) {
                    if (!(ihid instanceof RfHid)) continue;
                    IRfNamedElement element = ihid.getElement();
                    return element instanceof RfFunction && ((RfFunction)element).isFunction() && !((RfFunction)element).isPredefined();
                }
                return false;
            }
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

