/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractLiteralCheck;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="24.1.20")
@CheckID(value="R.1345")
@CheckName(value="R.1345")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE})
@CheckTitle(value="Do not use more digits than the specified size in based numbers")
@CheckDescription(value="This check flags numerical literal values with a size of the number larger than the specified size.\nIf the size of the number is larger than the size specified for the literal constant, the number shall be truncated from the left.\n\nExamples:\n\nbit[2:0] a = 3'b0001; // not allowed\nbit[2:0] b = 3'b1001; // not allowed\nbit[2:0] c = 3'b001;  // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1345
extends AbstractLiteralCheck {
    public Check_R_1345(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass[] allClasses;
        super.performCheckImpl();
        RfClass[] rfClassArray = allClasses = this.fOVMProject.getRfProject().getAllClasses();
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass clazz = rfClassArray[n2];
            DataType extendedDataType = clazz.getExtendedType();
            if (extendedDataType != null && extendedDataType.getParamValuesHolder() != null) {
                extendedDataType.getParamValuesHolder().visitHidObject(null, this.visitor);
            }
            ++n2;
        }
    }

    @Override
    protected void analyzeImplicit(RfHidImplicit hidImplicit, ParserPath parserPath, int line, int offset) {
        if (!hidImplicit.isNumber()) {
            return;
        }
        String text = hidImplicit.getName();
        if (!text.contains("'")) {
            return;
        }
        int length = text.length();
        StringBuilder number = new StringBuilder(length);
        int tickIndex = -1;
        int numberBase = 10;
        int nofSpecifiedBits = 0;
        int i = 0;
        while (i < length) {
            char currChar = text.charAt(i);
            if (currChar == '.') {
                return;
            }
            if (currChar != '_') {
                if (currChar == '\'') {
                    tickIndex = i;
                    if (number.length() == 0) {
                        return;
                    }
                    nofSpecifiedBits = Integer.parseInt(number.toString());
                    number.setLength(0);
                    if (i + 1 >= length) {
                        return;
                    }
                    char first = text.charAt(i + 1);
                    if (Character.isAlphabetic(first)) {
                        char baseChar = first;
                        ++i;
                        if (first == 's' || first == 'S') {
                            if (i + 1 >= length) {
                                return;
                            }
                            baseChar = text.charAt(i + 1);
                            ++i;
                        }
                        if ((numberBase = DVTStringUtil.numberBaseVLOG((char)baseChar)) <= 0) {
                            return;
                        }
                    }
                    first = text.charAt(i + 1);
                    while (Character.isWhitespace(first)) {
                        if (++i + 1 >= length) {
                            return;
                        }
                        first = text.charAt(i + 1);
                    }
                } else if (Character.isDigit(currChar)) {
                    number.append(currChar);
                } else if (currChar == 'X' || currChar == 'x' || currChar == 'z' || currChar == 'Z' || currChar == '?') {
                    number.append("0");
                } else {
                    if (tickIndex == -1 || numberBase != 16) {
                        return;
                    }
                    number.append(currChar);
                }
            }
            ++i;
        }
        if (nofSpecifiedBits == 0) {
            this.addLocalHit(parserPath, line, hidImplicit);
        }
        if (number.length() == 0) {
            return;
        }
        int nofActualDigits = this.getNofActualNumberCharacters(number, numberBase);
        if (numberBase != 10) {
            int baseLength = (int)(Math.log(numberBase) / Math.log(2.0));
            if (nofActualDigits * baseLength - nofSpecifiedBits < baseLength) {
                char leftmostChar = number.charAt(0);
                int leftmostDigit = Integer.parseInt(Character.toString(leftmostChar), numberBase);
                nofActualDigits = (nofActualDigits - 1) * baseLength + 32 - Integer.numberOfLeadingZeros(leftmostDigit);
            } else {
                nofActualDigits *= baseLength;
            }
        }
        if (nofSpecifiedBits < nofActualDigits) {
            this.addLocalHit(parserPath, line, hidImplicit);
        }
    }

    private int getNofActualNumberCharacters(StringBuilder number, int numberBase) {
        if (numberBase == 10) {
            try {
                int intNumber = Integer.parseInt(number.toString());
                return 32 - Integer.numberOfLeadingZeros(intNumber);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return number.length();
    }

    private void addLocalHit(ParserPath parserPath, int line, RfHidImplicit hidImplicit) {
        this.addHit(parserPath, line, "Based number " + hidImplicit.getName() + " has more digits than the specified size!", hidImplicit.getReparseInfo() instanceof ReparseInfo ? (ReparseInfo)hidImplicit.getReparseInfo() : null);
    }

    @Override
    protected boolean skipFunction(String functionFullName) {
        return false;
    }

    @Override
    protected boolean skipOperator(RfHidOperator hidOperator, ParserPath parserPath) {
        return false;
    }

    @Override
    protected boolean checkParameterAndConst() {
        return false;
    }
}

