/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="24.1.22")
@CheckID(value="R.1346")
@CheckName(value="R.1346")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.METHOD})
@CheckTitle(value="Method declaration formatting")
@CheckDescription(value="This rule checks there is only one whitespace in a function/task between return type/identifier/arguments.\n\nExamples:\n\nlocal function my_func(int a, int b);\t\t\t// allowed\nlocal function    my_func(int a, int b);\t\t// not allowed\nlocal function my_func(int   a, int b);\t\t// allowed iff ignoreMethodArgs is true\n\nCheck supports pre-waiving.")
public class Check_R_1346
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="false", description="When true, formatting is not checked for the method's arguments.", name="ignoreMethodArgs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pIgnoreMethodArgs;
    private static final String ERROR_MESSAGE = "Method ''{0}'' is incorrectly formatted!";

    public Check_R_1346(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void performCheckImpl() {
        allFunctionsAndTasks = new NullProtectedList<RfNamedElement>();
        allFunctionsAndTasks.addAll(this.fOVMProject.getAllFunctions());
        allFunctionsAndTasks.addAll(this.fOVMProject.getAllTasks());
        methodTypes = new HashSet<String>(Arrays.asList(new String[]{"function", "task"}));
        methodQualifiers = new HashSet<String>(Arrays.asList(new String[]{"static", "protected", "local"}));
        for (RfNamedElement method : allFunctionsAndTasks) {
            declarations = method.getDeclarations();
            for (RfDefElement declaration : declarations) {
                if (declaration == null || declaration.getReparseInfo() != null || this.checkPreWaivers(parserPath = declaration.getParserPath())) continue;
                this.notifyCheckAlive();
                currentToken = this.getWSParser().getTokenContainingOffset(declaration.getStartOffset(), parserPath);
                if (!currentToken.getStringToken().contains("(") && !currentToken.getStringToken().contains(";")) {
                    this.addHit(parserPath, currentToken.getLineNumber(), MessageFormat.format("Method ''{0}'' is incorrectly formatted!", new Object[]{method.getName()}), null);
                    continue;
                }
                argsStartOffset = currentToken.getStringToken().contains("(") != false ? Integer.valueOf(declaration.getStartOffset()) : null;
                while (currentToken != null && !methodTypes.contains(currentToken.getStringToken())) {
                    currentToken = this.getWSParser().getPrevCodeToken(currentToken, parserPath);
                }
                if (currentToken == null) continue;
                if (!declaration.isOutOfClassDefinition() && method.getEnclosingScope() instanceof RfClass) {
                    if (method.isExtern()) {
                        while (currentToken != null && !currentToken.getStringToken().equals("extern")) {
                            currentToken = this.getWSParser().getPrevCodeToken(currentToken, parserPath);
                        }
                    } else if (method.isPure()) {
                        while (currentToken != null && !currentToken.getStringToken().equals("pure")) {
                            currentToken = this.getWSParser().getPrevCodeToken(currentToken, parserPath);
                        }
                    } else if (method.hasVirtualQualifier()) {
                        while (currentToken != null && !currentToken.getStringToken().equals("virtual")) {
                            currentToken = this.getWSParser().getPrevCodeToken(currentToken, parserPath);
                        }
                    } else if (method.hasObjectStaticQualifier() || method.isProtected() || method.isPrivate()) {
                        prevToken = this.getWSParser().getPrevCodeToken(currentToken, parserPath);
                        while (prevToken != null && methodQualifiers.contains(prevToken.getStringToken())) {
                            currentToken = prevToken;
                            prevToken = this.getWSParser().getPrevCodeToken(prevToken, parserPath);
                        }
                    }
                } else if (method.hasObjectStaticQualifier() && (prevToken = this.getWSParser().getPrevCodeToken(currentToken, parserPath)) != null && prevToken.getStringToken().equals("static")) {
                    currentToken = prevToken;
                }
                if (currentToken != null) ** GOTO lbl51
                continue;
lbl-1000:
                // 1 sources

                {
                    currentToken = this.getWSParser().getNextCodeToken(currentToken, parserPath);
lbl51:
                    // 2 sources

                    ** while (this.checkCurrentToken((ParserPath)parserPath, (RfNamedElement)method, (LiteralToken)currentToken, (Integer)argsStartOffset))
                }
lbl52:
                // 1 sources

            }
        }
    }

    private boolean checkCurrentToken(ParserPath parserPath, RfNamedElement method, LiteralToken token, Integer argsStartOffset) {
        if (token == null || !token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE)) {
            return false;
        }
        String stringToken = token.getStringToken();
        if (this.pIgnoreMethodArgs && argsStartOffset != null && token.getOffsetFile() >= argsStartOffset) {
            if (stringToken.equals(";")) {
                this.addHit(parserPath, token.getLineNumber(), MessageFormat.format(ERROR_MESSAGE, method.getName()), null);
                return false;
            }
            return !stringToken.contains(";");
        }
        if ((stringToken.startsWith("(") || stringToken.startsWith(")")) && token.getNoSpacesBefore() > 0 && !token.isFirstTokenOnLine()) {
            this.addHit(parserPath, token.getLineNumber(), MessageFormat.format(ERROR_MESSAGE, method.getName()), null);
            return false;
        }
        if (stringToken.startsWith(",") && token.getNoSpacesBefore() > 0) {
            this.addHit(parserPath, token.getLineNumber(), MessageFormat.format(ERROR_MESSAGE, method.getName()), null);
            return false;
        }
        if (stringToken.endsWith("(") && token.getNoSpacesAfter() > 0) {
            this.addHit(parserPath, token.getLineNumber(), MessageFormat.format(ERROR_MESSAGE, method.getName()), null);
            return false;
        }
        if (stringToken.contains(",") && !stringToken.endsWith(",")) {
            this.addHit(parserPath, token.getLineNumber(), MessageFormat.format(ERROR_MESSAGE, method.getName()), null);
            return false;
        }
        if (stringToken.startsWith("::") || stringToken.endsWith("::")) {
            this.addHit(parserPath, token.getLineNumber(), MessageFormat.format(ERROR_MESSAGE, method.getName()), null);
            return false;
        }
        if (stringToken.equals(";")) {
            this.addHit(parserPath, token.getLineNumber(), MessageFormat.format(ERROR_MESSAGE, method.getName()), null);
            return false;
        }
        if (stringToken.contains(";")) {
            return false;
        }
        if (token.getNoSpacesAfter() > 1 || token.getNoTabsAfter() > 0) {
            this.addHit(parserPath, token.getLineNumber(), MessageFormat.format(ERROR_MESSAGE, method.getName()), null);
            return false;
        }
        return true;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

