/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="24.1.21")
@CheckID(value="R.1347")
@CheckName(value="R.1347")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.COVERGROUP, RuleLabel.OPTION})
@CheckTitle(value="Set the per_instance option of each covergroup")
@CheckDescription(value="By default the per_instance option of a covergroup is set as 0 and for such cases the coverage for the covergroup instance is not reported.\nIn order to have coverage information of instances printed in the coverage report, the per_instance option must be set to 1.\nThis rule checks that for each covergroup the 'per_instance' option is set.\n\nExample:\ncovergroup cg1;\t\t\t// allowed\n\toption.per_instance = 1;\n\tcoverpoint x;\nendgroup\n\ncovergroup cg2;\t\t\t// not allowed\n\tcoverpoint x;\nendgroup\n\nCheck supports pre-waiving.")
public class Check_R_1347
extends OVMComplianceCheck {
    boolean hit;

    public Check_R_1347(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement cg : this.fOVMProject.getAllCovergroups()) {
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(cg.getDeclaration().getParserPath(), this)) {
                return;
            }
            this.hit = true;
            cg.visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)new HidOperatorVisitor(null){

                public boolean visit(HidOperator operator) {
                    if (!operator.isAssignment()) {
                        return true;
                    }
                    Check_R_1347.this.notifyCheckAlive();
                    IHidObject lhValue = operator.getLHValue();
                    if (lhValue == null || !(lhValue instanceof RfHid)) {
                        return true;
                    }
                    RfHid leftValue = (RfHid)operator.getLHValue();
                    if (!leftValue.getName().equals("per_instance")) {
                        return true;
                    }
                    Hid parentHid = leftValue.getParentHid();
                    if (parentHid == null || !parentHid.getName().equals("option")) {
                        return true;
                    }
                    IRfNamedElement element = parentHid.getElement();
                    if (element == null) {
                        return true;
                    }
                    IRfScopeElement enclosingScope = element.getEnclosingScope();
                    if (!(enclosingScope instanceof RfCovergroup)) {
                        return true;
                    }
                    Check_R_1347.this.hit = false;
                    return false;
                }
            });
            if (!this.hit) continue;
            this.addHit(cg, "Covergroup '" + cg.getName() + "' does not set the 'per_instance' option!");
        }
    }
}

