/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.22")
@CheckID(value="R.1348")
@CheckName(value="R.1348")
@CheckLabel(labels={RuleLabel.STRING, RuleLabel.PREDEFINED_METHOD, RuleLabel.FORMAT_SPECIFIER})
@CheckTitle(value="Do not use %v format specifier with multi-bit variable")
@CheckDescription(value="The strength format specifier (%v) must not be used for multi-bit values for all printing methods as it may not be supported by all simulators.\n\nExample:\n  $sformatf(\"%v\", arr[3:0]);    // not allowed\n  $sformatf(\"%v\", arr[3]);      // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1348
extends OVMComplianceCheck {
    private static final Pattern GENERATE_BLOCK_PATH_SEPARATOR = Pattern.compile(", ");

    public Check_R_1348(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        final ELManager manager = rfProject.getELManager();
        final ELParamValuesHidEvaluator emptyEvaluator = ELParamValues.EMPTY.getHidEvaluator(manager);
        RfMixedLangProject mixedLangProject = rfProject.getMixedLangProjectParent();
        final Map specsPerElement = mixedLangProject.getLinterElabSpecs();
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){
            private IRfNamedElement scope;

            public boolean visit(RfHid hid) {
                if (Check_R_1348.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    if (!LintUtilsConstants.PRINT_TASKS.contains(methodCall.getMethodName())) continue;
                    Check_R_1348.this.notifyCheckAlive();
                    if (methodCall.argumentValuesMap == null || methodCall.argumentValuesMap.isEmpty()) continue;
                    String specifiers = null;
                    Map argumentValuesMapRaw = methodCall.argumentValuesMapRaw;
                    for (Map.Entry argumentValue : argumentValuesMapRaw.entrySet()) {
                        IRfNamedElement key = (IRfNamedElement)argumentValue.getKey();
                        IHidObject value = (IHidObject)argumentValue.getValue();
                        if (!(key instanceof RfPredefinedField) || !(value instanceof RfHidImplicit)) continue;
                        specifiers = ((RfHidImplicit)value).getName();
                        break;
                    }
                    if (specifiers == null || specifiers.isEmpty()) continue;
                    List<String> listOfSpecifiers = this.createListOfSpecifiers(specifiers);
                    int indexInSpecifiers = 0;
                    for (Map.Entry argumentValue : argumentValuesMapRaw.entrySet()) {
                        IRfNamedElement key = (IRfNamedElement)argumentValue.getKey();
                        IHidObject value = (IHidObject)argumentValue.getValue();
                        if (!(key instanceof RfField) || !((RfField)key).getName().startsWith("list_of_arguments") || indexInSpecifiers >= listOfSpecifiers.size()) continue;
                        String specifier = listOfSpecifiers.get(indexInSpecifiers);
                        ++indexInSpecifiers;
                        if (!specifier.equalsIgnoreCase("v")) continue;
                        if (value instanceof RfHidAccess) {
                            this.analyzeAcces((RfHidAccess)value);
                        }
                        if (value instanceof RfHidAccessArgs) {
                            value = ((RfHidAccessArgs)value).getParentHid();
                        }
                        if (!(value instanceof RfHid)) continue;
                        this.analyzeHid((RfHid)value);
                    }
                }
                return true;
            }

            private void analyzeAcces(RfHidAccess access) {
                Hid parentHid = access.getParentHid();
                if (!(parentHid instanceof RfHid)) {
                    return;
                }
                RfHid valueHid = (RfHid)parentHid;
                ListContainer accesses = valueHid.getAccesses();
                if (accesses == null) {
                    return;
                }
                List selects = ((HidAccess)accesses.get(0)).getSelects();
                if (selects == null) {
                    return;
                }
                IRfNamedElement arrayElement = valueHid.getElement();
                if (arrayElement == null || !(arrayElement instanceof RfAssociatedType)) {
                    return;
                }
                RfNamedElement arrayElementType = LintUtils.getAssociatedFinalType((RfAssociatedType)arrayElement);
                if (arrayElementType != null && "string".equals(arrayElementType.getName())) {
                    return;
                }
                this.checkSize(valueHid, access, this.scope, selects, arrayElement, manager, emptyEvaluator, specsPerElement, this.parserPath);
            }

            private void analyzeHid(RfHid hid) {
                IRfNamedElement arrayElement = hid.getElement();
                if (arrayElement == null || !(arrayElement instanceof RfAssociatedType)) {
                    return;
                }
                IRfNamedElement arrayFieldAssocType = ((RfAssociatedType)arrayElement).getAssociatedType();
                while (arrayFieldAssocType instanceof RfTypeAlias) {
                    arrayFieldAssocType = ((RfTypeAlias)arrayFieldAssocType).getAssociatedType();
                }
                if (arrayFieldAssocType == null || RfListType.isNotFixedArray((IRfScopeElement)arrayFieldAssocType)) {
                    return;
                }
                if (!(arrayFieldAssocType.getDeclaration() instanceof RfDefElement)) {
                    return;
                }
                DataType dataType = ((RfDefElement)arrayFieldAssocType.getDeclaration()).getDataType(arrayElement);
                if (dataType == null) {
                    return;
                }
                List<IndexType> packedDimensionsList = dataType.getPackedDimension();
                if (packedDimensionsList == null || packedDimensionsList.isEmpty()) {
                    return;
                }
                ArrayList<IHidObject> dimensions = new ArrayList<IHidObject>();
                for (IndexType dimension : packedDimensionsList) {
                    IHidObject range = dimension.getRangeObject();
                    if (range == null) continue;
                    dimensions.add(range);
                }
                if (dimensions.isEmpty()) {
                    return;
                }
                this.checkSize(hid, null, this.scope, dimensions, arrayElement, manager, emptyEvaluator, specsPerElement, this.parserPath);
            }

            /*
             * Unable to fully structure code
             */
            private List<String> createListOfSpecifiers(String specifiers) {
                listOfSpecifiers = new ArrayList<String>();
                numberOfPercents = 0;
                i = 0;
                ** GOTO lbl17
                {
                    if (specifiers.charAt(i) == '%') {
                        ++numberOfPercents;
                    }
                    ++i;
                    do {
                        if (i < specifiers.length() && (specifiers.charAt(i) == '%' || specifiers.charAt(i) == '0')) continue block0;
                        if (numberOfPercents % 2 == 0) {
                            numberOfPercents = 0;
                        } else {
                            listOfSpecifiers.add(String.valueOf(specifiers.charAt(i)));
                            numberOfPercents = 0;
                        }
                        ++i;
lbl17:
                        // 2 sources

                    } while (i < specifiers.length());
                }
                return listOfSpecifiers;
            }

            private void checkSize(RfHid hid, RfHidAccess hidAccess, IRfNamedElement scope, List<IHidObject> sizeToCheck, IRfNamedElement arrayElement, ELManager elManager, ELParamValuesHidEvaluator emptyEvaluator2, Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> specsPerElement2, ParserPath parserPath) {
                Map<ELSpecializationWrapper, ELSpecializationWrapper> specializationWrappers;
                Map.Entry<ELSpecializationWrapper, ELSpecializationWrapper> entry;
                ELSpecializationWrapper generateBlockWrapper;
                Map<ELSpecializationWrapper, ELSpecializationWrapper> generateBlock;
                RfGenerateBlock generateBlockScope;
                if (!(arrayElement instanceof RfAssociatedType)) {
                    return;
                }
                String[] generateBlockPaths = null;
                if (scope != null && scope instanceof RfGenerateBlock && ((generateBlockScope = (RfGenerateBlock)scope).isIfGenerate() || generateBlockScope.isElseGenerate() || generateBlockScope.isCaseItemGenerate() || generateBlockScope.isCaseOthersGenerate()) && (generateBlock = specsPerElement2.get(scope)) != null && !generateBlock.isEmpty() && (generateBlockWrapper = (entry = generateBlock.entrySet().iterator().next()).getKey()) != null) {
                    generateBlockPaths = GENERATE_BLOCK_PATH_SEPARATOR.split(generateBlockWrapper.getPathsText());
                }
                IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)arrayElement, null, (boolean)false, (ELManager)elManager);
                IRfScopeElement enclosingScope = arrayElement.getEnclosingScope(RfModule.class);
                Map<ELSpecializationWrapper, ELSpecializationWrapper> map = specializationWrappers = enclosingScope != null ? specsPerElement2.get(enclosingScope) : null;
                if (specializationWrappers != null && !specializationWrappers.isEmpty()) {
                    for (ELSpecializationWrapper wrapper : specializationWrappers.values()) {
                        IHidEvaluator specializationEvaluator = wrapper.getHidEvaluator(elManager);
                        if (!(specializationEvaluator instanceof ELParamValuesHidEvaluator)) continue;
                        String pathsText = wrapper.getPathsText();
                        if (generateBlockPaths != null) {
                            boolean foundCorrespondingGenerateBlockPath = false;
                            String[] stringArray = generateBlockPaths;
                            int n = generateBlockPaths.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String generateBlockPath = stringArray[n2];
                                if (generateBlockPath.startsWith(pathsText)) {
                                    foundCorrespondingGenerateBlockPath = true;
                                }
                                ++n2;
                            }
                            if (!foundCorrespondingGenerateBlockPath) continue;
                        }
                        this.checkSelectSize(hid, hidAccess, scope, sizeToCheck, guardian, parserPath, (ELParamValuesHidEvaluator)specializationEvaluator, pathsText);
                    }
                } else {
                    this.checkSelectSize(hid, hidAccess, scope, sizeToCheck, guardian, parserPath, emptyEvaluator2, null);
                }
            }

            private void checkSelectSize(RfHid hid, RfHidAccess hidAccess, IRfNamedElement scope, List<IHidObject> selects, IHidEvaluationGuardian guardian, ParserPath parserPath, ELParamValuesHidEvaluator evaluator, String paths) {
                BitVectorContext dummyContextOrigin = BitVectorContext.of((IRfNamedElement)scope, (boolean)false);
                for (IHidObject select : selects) {
                    int smallDimension;
                    int bigDimension;
                    IELParamValue rhValue;
                    IELParamValue lhValue;
                    ListContainer rhValues;
                    RfHidOperator selectOp;
                    if (!(select instanceof RfHidOperator) || !(selectOp = (RfHidOperator)select).isRangeOrPartSelect() || (rhValues = selectOp.getRHValues()) == null || rhValues.size() != 1 || ELUtils.isUnsuccessfulEval((IELParamValue)(lhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)selectOp.getLHValue(), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian)))) || !(lhValue instanceof ELParamValues.ParamValueNumber) || ELUtils.isUnsuccessfulEval((IELParamValue)(rhValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)rhValues.get(0)), (IHidEvaluator)evaluator, (BitVectorContext)dummyContextOrigin, (IHidEvaluationGuardian)guardian)))) || !(rhValue instanceof ELParamValues.ParamValueNumber) || (bigDimension = lhValue.intValue()) - (smallDimension = rhValue.intValue()) == 0) continue;
                    String hitMessage = "Multi-bit values of '" + HidUtils.toNiceString((IHidObject)hid) + "' are not allowed for the %v format specifier!\n";
                    hitMessage = hidAccess != null ? String.valueOf(hitMessage) + "The access '" + HidUtils.toNiceString((IHidObject)hidAccess) + "' was resolved to '" + bigDimension + ":" + smallDimension + "'." : String.valueOf(hitMessage) + "The packed dimensions were resolved to '" + bigDimension + ":" + smallDimension + "'.";
                    hitMessage = String.valueOf(hitMessage) + (paths != null ? "\nHierarchy Paths: " + paths : "");
                    Check_R_1348.this.addHit(parserPath, hid.getOccurrence(), hitMessage, true);
                }
            }

            @Override
            public void setHolder(IHidHolder holder) {
                if (holder instanceof RfHidHolder) {
                    this.scope = ((RfHidHolder)holder).getScope();
                }
            }

            @Override
            public Class<RfHid> getType() {
                return RfHid.class;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

