/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="24.1.22")
@CheckID(value="R.1349")
@CheckName(value="R.1349")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.NAME, RuleLabel.SHADOWING})
@CheckTitle(value="Do not declare variables with the same name as virtual methods from parent classes")
@CheckDescription(value="This rule flags class fields that have the same name as virtual methods from parent classes.\nNaming such methods the same as fields will result in the methods being hidden.\n\nExample:\n\nclass base;\n\tvirtual function void start();\n\tendfunction\nendclass\n\nclass child extends base;\n\tint start;\t\t// not allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1349
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Field ''{0}'' has the same name as virtual method ''{1}'' from parent class!";

    public Check_R_1349(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            RfFileDef file;
            if (!(clazz instanceof RfClass) || (file = clazz.getFile()) == null || this.checkPreWaivers(file.getParserPath())) continue;
            this.notifyCheckAlive();
            this.checkClass((RfClass)clazz);
        }
    }

    public void checkClass(RfClass clazz) {
        List<RfField> allFields = clazz.getFields();
        if (allFields == null || allFields.isEmpty()) {
            return;
        }
        if ((clazz = clazz.getParent()) == null) {
            return;
        }
        block0: for (RfField field : allFields) {
            List<RfFunction> tasks;
            ArrayList<RfFunction> methods = new ArrayList<RfFunction>();
            List<RfFunction> functions = clazz.getFunctionsWithPrefix(field.getName(), 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (functions != null && !functions.isEmpty()) {
                methods.addAll(functions);
            }
            if ((tasks = clazz.getTasksWithPrefix(field.getName(), 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) != null && !tasks.isEmpty()) {
                methods.addAll(tasks);
            }
            if (methods == null || methods.isEmpty()) continue;
            for (RfFunction method : methods) {
                if (!method.isVirtual()) continue;
                this.addHit(field, MessageFormat.format(ERROR_MESSAGE, LintUtils.getNamedElementFullName(field), LintUtils.getNamedElementFullName(method)));
                continue block0;
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

