/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="24.1.22")
@CheckID(value="R.1350")
@CheckName(value="R.1350")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.TASK, RuleLabel.ALWAYS})
@CheckTitle(value="Do not call tasks from always blocks")
@CheckDescription(value="This check flags tasks called from always blocks.\nAlways blocks provide an inferred sensitivity list by automatically detecting the sensitivity based on the statements from the always block.\nBy calling tasks in always blocks, only the arguments of the task will be added to the sensitivity list, which can be misleading and could result in hard to debug scenarios.\n\nExample:\n\nmodule top;\n\n\talways_comb begin\n\t\tstart();\t\t// not allowed\n\tend\n\n\ttask start();\n\tendtask\n\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1350
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Calling the ''{0}'' task from an always block is not allowed!";

    public Check_R_1350(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List alwaysBlocks = this.fOVMProject.getRfProject().getAllActionBlocks().stream().filter(RfActionBlock::isAlways).collect(Collectors.toList());
        if (alwaysBlocks == null || alwaysBlocks.isEmpty()) {
            return;
        }
        LocalBlockVisitor blockVisitor = new LocalBlockVisitor();
        for (RfActionBlock block : alwaysBlocks) {
            RfFileDef file = block.getFile();
            if (file == null || this.checkPreWaivers(file.getParserPath())) continue;
            this.notifyCheckAlive();
            block.visitHidObject(null, blockVisitor);
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalBlockVisitor
    extends RfHidVisitor {
        private LocalBlockVisitor() {
        }

        public boolean visit(RfHid hidObject) {
            if (!(hidObject.getElement() instanceof RfFunction)) {
                return true;
            }
            RfFunction hidElement = (RfFunction)hidObject.getElement();
            if (!hidElement.isTask() || hidElement.isPredefined()) {
                return true;
            }
            Check_R_1350.this.addHit(this.parserPath, hidObject, MessageFormat.format(Check_R_1350.ERROR_MESSAGE, LintUtils.getHidFullName((IHid)hidObject)));
            return true;
        }
    }
}

